/*  
 * 	gpoint/gdl_gpoint.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:53 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_GPOINT_H__
#define __GDL_GPOINT_H__

#include <gdl/gdl_common.h>

__BEGIN_DECLS

typedef enum _gdl_gpoint_type gdl_gpoint_type;

typedef struct
{
	size_t idx;
	const gdl_gpoint_type * type;
} gdl_gpoint;

gdl_gpoint * gdl_gpoint_alloc (const gdl_gpoint_type * type);
void gdl_gpoint_free (gdl_gpoint * g);
gdl_gpoint * gdl_gpoint_clone (const gdl_gpoint * g);
int gdl_gpoint_compare (const gdl_gpoint * g1, const gdl_gpoint * g2);
gdl_gpoint * gdl_gpoint_fread (FILE * stream);
int gdl_gpoint_fwrite (FILE * stream, const gdl_gpoint * g);


typedef struct
{
   size_t idx;
   double value;
} gdl_gvalue;

typedef struct
{
  size_t size;
  gdl_gvalue ** values;
} gdl_gvalues;

gdl_gvalue * gdl_gvalue_alloc (void);
void gdl_gvalue_free (gdl_gvalue * g);
int gdl_gvalue_compare (const gdl_gvalue * g1, const gdl_gvalue * g2);
int gdl_gvalue_copy (gdl_gvalue * g0, const gdl_gvalue * g1);
gdl_gvalue * gdl_gvalue_clone (const gdl_gvalue * g);
gdl_gvalue * gdl_gvalue_fread (FILE * stream);
int gdl_gvalue_fwrite (FILE * stream, const gdl_gvalue * g);

gdl_gvalues * gdl_gvalues_alloc (size_t size);
void gdl_gvalues_free (gdl_gvalues * g);
int gdl_gvalues_copy (gdl_gvalues * g0, const gdl_gvalues * g1);
gdl_gvalues * gdl_gvalues_clone (const gdl_gvalues * g);
int gdl_gvalues_compare (const gdl_gvalues * g1, const gdl_gvalues * g2);
gdl_gvalues * gdl_gvalues_fread (FILE * stream);
int gdl_gvalues_fwrite (FILE * stream, const gdl_gvalues * g);
const gdl_gvalue * gdl_gvalues_get_max (const gdl_gvalues * g);

typedef struct _gdl_gvalues_registry gdl_gvalues_registry;

gdl_gvalues_registry * gdl_gvalues_registry_alloc ();
void gdl_gvalues_registry_free (gdl_gvalues_registry * b);
gdl_gvalues_registry * gdl_gvalues_registry_fread (FILE * stream);
int gdl_gvalues_registry_fwrite (FILE * stream, const gdl_gvalues_registry * g);
int gdl_gvalues_registry_add (gdl_gvalues_registry * b, const gdl_gvalues * values);
gdl_gvalues * gdl_gvalues_registry_get (gdl_gvalues_registry * b, size_t i);
// remove ?

typedef struct
{
	size_t size;
	gdl_boolean is_phased;
	const gdl_gpoint_type * type;
	gdl_gvalues           ** values;
} gdl_gregistry_entry;

gdl_gregistry_entry * gdl_gregistry_entry_alloc (const gdl_gpoint_type * type, size_t size);
void gdl_gregistry_entry_free (gdl_gregistry_entry * gre);

typedef struct _gdl_gregistry gdl_gregistry;

gdl_gregistry * gdl_gregistry_alloc (size_t ploidy);
void gdl_gregistry_free (gdl_gregistry * gr);
gdl_gregistry * gdl_gregistry_fread (FILE * stream);
int gdl_gregistry_fwrite (FILE * stream, const gdl_gregistry * gr);
gdl_gpoint  * gdl_gregistry_add (gdl_gregistry * gr, gdl_gregistry_entry * ge);
int gdl_gregistry_add_gpoint (gdl_gregistry * gr, gdl_gpoint ** gp);
gdl_gregistry_entry * gdl_gregistry_get (gdl_gregistry * gr, gdl_gpoint * gp);
gdl_boolean gdl_gregistry_is_homozygous (gdl_gregistry * g, gdl_gpoint * gp);
gdl_boolean gdl_gregistry_has_missing (gdl_gregistry * g, gdl_gpoint * gp);
gdl_boolean gdl_gregistry_is_missing (gdl_gregistry * g, gdl_gpoint * gp, size_t k);

typedef gdl_gregistry_entry gdl_gdatapoint;
typedef struct _gdl_gdatapoints gdl_gdatapoints;

int gdl_gdatapoint_compare (const gdl_gdatapoint * g1, const gdl_gdatapoint * g2);

gdl_gdatapoint * gdl_gdatapoint_alloc (const gdl_gpoint_type * type, size_t size);
void gdl_gdatapoint_free (gdl_gdatapoint * g);

gdl_gdatapoints * gdl_gdatapoints_alloc (size_t p, size_t n, size_t l);
void gdl_gdatapoints_free (gdl_gdatapoints * g);
gdl_gdatapoints * gdl_gdatapoints_fread (FILE * stream);
int gdl_gdatapoints_fwrite (FILE * stream, const gdl_gdatapoints * g);
int gdl_gdatapoints_set (gdl_gdatapoints * g, size_t i, size_t j, gdl_gdatapoint * x);
gdl_gdatapoint * gdl_gdatapoints_get (gdl_gdatapoints * g, size_t i, size_t j);
gdl_boolean gdl_gdatapoints_is_homozygous (gdl_gdatapoints * g, size_t i, size_t j);
gdl_boolean gdl_gdatapoints_has_missing (gdl_gdatapoints * g, size_t i, size_t j);
gdl_boolean gdl_gdatapoints_is_missing (gdl_gdatapoints * g, size_t i, size_t j, size_t k);
int gdl_gdatapoints_compare (const gdl_gdatapoints * g, size_t i, size_t j, size_t ii, size_t jj);

typedef struct
{
	size_t size;
	gdl_boolean na;
	gdl_gvalues * x;
} gdl_gvalues_get;

gdl_gvalues_get * gdl_gvalues_get_alloc (size_t size);
void gdl_gvalues_get_free (gdl_gvalues_get * get);
const gdl_gvalues * gdl_gvalues_get_gvalues (gdl_gvalues_get * vg);

GDL_VAR const gdl_data_interface * gdl_gpoint_interface;
GDL_VAR const gdl_data_interface * gdl_gvalues_interface;
GDL_VAR const gdl_gpoint_type * gdl_gpoint_haplo;
GDL_VAR const gdl_gpoint_type * gdl_gpoint_geno;
GDL_VAR const gdl_gpoint_type * gdl_gpoint_missing;

__END_DECLS

#endif /* __GDL_GPOINT_H__ */
