/*  
 *  graphics/font
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:52 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_graphics.h>

gdl_font_ptr
gdl_font_alloc()
{
  gdl_font_ptr  gptr = NULL;

  gptr = GDL_CALLOC (gdl_font, 1);

  return gptr;	
}

void
gdl_font_free(gdl_font_ptr ptr)
{
	if (ptr != NULL) {
		GDL_FREE (ptr->name);
		GDL_FREE (ptr->family);
		GDL_FREE (ptr);
	}
}

gdl_font *
gdl_font_default (void)
{
	gdl_font_ptr font = gdl_font_alloc();	
	
	font->size  = 10;
	font->style = GDL_FONT_PLAIN;
	
	return font;
}
/**
 * 
 * 
 * 
 */
void
gdl_font_copy (gdl_font_ptr dest, gdl_font_ptr src)
{
	if (dest == NULL || src == NULL) return;
	
	dest->size  = src->size;
	dest->style = src->style;
	gdl_string_free (dest->name);
	gdl_string_free (dest->family);
	dest->name   = gdl_string_clone (src->name);
	dest->family = gdl_string_clone (src->family);
}

int
gdl_font_fprintf (FILE * stream, const gdl_font * font)
{
	if (stream && font)
	{
		fprintf (stream, "%s %s %d %d", (font->name) ? font->name : "-",
		                                (font->family) ? font->family : "-",
		                                font->size,
		                                font->style);
		return GDL_SUCCESS;
	}
	
	return GDL_EINVAL;
}

gdl_font *
gdl_font_fscanf (FILE * stream)
{
	if (stream)
	{
		int status;
		gdl_font * font;
		gdl_string * name, * family;
		
		font   = gdl_font_alloc ();
		
		name   = gdl_string_alloc (100);
		family = gdl_string_alloc (100);
		
		fscanf (stream, "%s %s %d %d", name, family, &(font->size), &(font->style));
		
		font->name   = (!strcmp(name,   "-")) ? NULL : gdl_string_clone (name);
		font->family = (!strcmp(family, "-")) ? NULL : gdl_string_clone (family);
		
		gdl_string_free (name);
		gdl_string_free (family);
		
		return font;
	}
	
	return NULL;
}
