/*  
 *  graphics/gdl_graphics_font.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:52 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 

#ifndef __GDL_GRAPHICS_RGB_H__
#define __GDL_GRAPHICS_RGB_H__

#include <stdio.h>

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>

__BEGIN_DECLS

typedef struct gdl_rgb_color {
	unsigned long hex;
	char *strhex;
	int  red;
	int  green;
	int  blue;	
	double alpha;
} gdl_rgb_color;

typedef gdl_rgb_color * gdl_rgb_color_ptr;



typedef struct
{
	size_t size;
	gdl_rgb_color * * colors;	
} gdl_rgb_color_vector;
/**
 * 
 */
gdl_rgb_color * gdl_rgb_color_alloc();
void gdl_rgb_color_free(gdl_rgb_color * color);
gdl_rgb_color_vector * gdl_rgb_color_vector_alloc (size_t n);
void gdl_rgb_color_vector_free(gdl_rgb_color_vector * v);
gdl_rgb_color * gdl_rgb_color_create(int r, int g, int b);
void gdl_rgb_color_rgb2str(char *str, int r, int g, int b);
void  gdl_rgb_color_comp2str(char *str, int val);
gdl_rgb_color_vector * gdl_rgb_color_gradient(gdl_rgb_color * from, gdl_rgb_color * to, size_t n);
gdl_rgb_color_vector * gdl_rgb_color_palette(size_t ncolor);
void gdl_rgb_color_l2rgb(long color, int *r, int *g, int *b);
void gdl_rgb_color_rgb2l(long *color, int r, int g, int b);
void gdl_rgb_color_l2str(long color, char *string);
void gdl_rgb_color_copy(gdl_rgb_color * dest, gdl_rgb_color * src);

gdl_rgb_color * gdl_rgb_color_get_white();
gdl_rgb_color * gdl_rgb_color_get_black();
gdl_rgb_color * gdl_rgb_color_get_red();
gdl_rgb_color * gdl_rgb_color_get_green();
gdl_rgb_color * gdl_rgb_color_get_blue();
gdl_rgb_color * gdl_rgb_color_get_yellow();

int gdl_rgb_color_fprintf (FILE *stream, const gdl_rgb_color * color);
gdl_rgb_color * gdl_rgb_color_fscanf (FILE *stream);

__END_DECLS

#endif
