/*  
 *  graphics/gdl_graphics_transform.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:52 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_GRAPHICS_TRANSFORM_H__
#define __GDL_GRAPHICS_TRANSFORM_H__

#include <stdio.h>

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>

__BEGIN_DECLS

enum {
	GDL_GRAPHICS_IDENTITY    = 0,
	GDL_GRAPHICS_TRANSLATION = 1,
	GDL_GRAPHICS_ROTATION    = 2,
	GDL_GRAPHICS_SCALE       = 3
};

typedef struct gdl_affine_transform {
	int type;
	double **matrix;
	struct gdl_affine_transform *next;
	struct gdl_affine_transform *prev;
} gdl_affine_transform;

typedef gdl_affine_transform *gdl_affine_transform_ptr;

gdl_affine_transform_ptr gdl_affine_transform_alloc();
void gdl_affine_transform_free(gdl_affine_transform_ptr ptr);
void gdl_affine_transform_new(gdl_affine_transform_ptr *ptr);
gdl_affine_transform_ptr gdl_affine_transform_first(gdl_affine_transform_ptr ptr);
gdl_affine_transform_ptr gdl_affine_transform_last(gdl_affine_transform_ptr ptr);
void gdl_affine_transform_clear(gdl_affine_transform_ptr ptr);
gdl_affine_transform_ptr gdl_affine_transform_delete(gdl_affine_transform_ptr gptr);
gdl_affine_transform_ptr gdl_affine_transform_move_to_front(gdl_affine_transform_ptr gptr);
gdl_affine_transform_ptr gdl_affine_transform_clone(gdl_affine_transform_ptr ptr);
gdl_affine_transform_ptr gdl_affine_transform_rotation(double theta);
gdl_affine_transform_ptr gdl_affine_transform_anchor_rotation(double x, double y, double theta);
gdl_affine_transform_ptr gdl_affine_transform_translation(double x, double y);
gdl_affine_transform_ptr gdl_affine_transform_scale(double sx, double sy);
void gdl_affine_transform_apply(gdl_affine_transform_ptr transform, double x, double y, double *tx, double *ty);
gdl_affine_transform_ptr gdl_affine_transform_concat(gdl_affine_transform_ptr t1, gdl_affine_transform_ptr t2);

__END_DECLS

#endif
