/*  
 *  graphics/shape2D.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:52 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h> 
#include <gdl/gdl_graphics.h>
/**
 * 
 */
void
gdl_graphics2D_draw_line(gdl_graphics2D_ptr graph, double x1, double y1, double x2, double y2)
{
	double xx1,xx2,yy1,yy2;
	
	gdl_graphics2D_transform(graph, x1, y1, &xx1, &yy1);
	gdl_graphics2D_transform(graph, x2, y2, &xx2, &yy2);
	
	switch(graph->device) {
		case GDL_GRAPHICS_DEVICE_PS	:
		    gdl_graphics2D_draw_line_ps(graph, xx1, yy1, xx2, yy2);
			break;
		case GDL_GRAPHICS_DEVICE_SVG :
		    gdl_graphics2D_draw_line_svg(graph, xx1, yy1, xx2, yy2); 
			break;
		default :
			break;
	}
}
/**
 * 
 * 
 */
void
gdl_graphics2D_draw_rect(gdl_graphics2D_ptr graph, double x, double y, double width, double height)
{
	double xx1,xx2,yy1,yy2;
	
	gdl_graphics2D_transform(graph, x, y, &xx1, &yy1);
	gdl_graphics2D_transform(graph, x+width, y+height, &xx2, &yy2);
	
	xx2 -= xx1;
	yy2 -= yy1;
	
	switch(graph->device) {
		case GDL_GRAPHICS_DEVICE_PS	:
		    gdl_graphics2D_draw_rect_ps(graph, xx1, yy1, xx2, yy2);
			break;
		case GDL_GRAPHICS_DEVICE_SVG :
		    gdl_graphics2D_draw_rect_svg(graph, xx1, yy1, xx2, yy2);
			break;
		default :
			break;
	}
}
/**
 * 
 * 
 */
void
gdl_graphics2D_fill_rect(gdl_graphics2D_ptr graph, double x, double y, double width, double height)
{
	double xx1,xx2,yy1,yy2;
	
	gdl_graphics2D_transform(graph, x, y, &xx1, &yy1);
	gdl_graphics2D_transform(graph, x+width, y+height, &xx2, &yy2);
	
	xx2 -= xx1;
	yy2 -= yy1;
	
	switch(graph->device) {
		case GDL_GRAPHICS_DEVICE_PS	:
			gdl_graphics2D_fill_rect_ps(graph, xx1, yy1, xx2, yy2);
			break;
		case GDL_GRAPHICS_DEVICE_SVG :
		    gdl_graphics2D_fill_rect_svg(graph, xx1, yy1, xx2, yy2);
			break;
		default :
			break;
	}
}
/**
 * 
 */
void 
gdl_graphics2D_draw_circle(gdl_graphics2D_ptr graph, double x, double y, double r)
{
	double xx1,xx2,yy1,yy2;
	
	gdl_graphics2D_transform(graph, x, y, &xx1, &yy1);
	gdl_graphics2D_transform(graph, x+r, y+r, &xx2, &yy2);
	
	xx2 -= xx1;
	
	switch(graph->device) {
		case GDL_GRAPHICS_DEVICE_PS	:
			gdl_graphics2D_draw_circle_ps(graph, xx1, yy1, xx2);
			break;
		case GDL_GRAPHICS_DEVICE_SVG :
			gdl_graphics2D_draw_circle_svg(graph, xx1, yy1, xx2);
			break;
		default :
			break;
	}
}
/**
 * 
 */
void 
gdl_graphics2D_fill_circle(gdl_graphics2D_ptr graph, double x, double y, double r)
{
	double xx1,xx2,yy1,yy2;
	
	gdl_graphics2D_transform(graph, x, y, &xx1, &yy1);
	gdl_graphics2D_transform(graph, x+r, y+r, &xx2, &yy2);
	
	xx2 -= xx1;
	
	switch(graph->device) {
		case GDL_GRAPHICS_DEVICE_PS	:
			gdl_graphics2D_draw_circle_ps(graph, xx1, yy1, xx2);
			break;
		case GDL_GRAPHICS_DEVICE_SVG :
		    gdl_graphics2D_draw_circle_svg(graph, xx1, yy1, xx2);
			break;
		default :
			break;
	}
}
/**
 * 
 */
void 
gdl_graphics2D_draw_path(gdl_graphics2D_ptr graph, double *x, double *y, int np, int close)
{
	int i;
	double *xx,*yy;
	
	xx = GDL_CALLOC (double, np);
	yy = GDL_CALLOC (double, np);
	
	for(i=0;i<np;i++)
		gdl_graphics2D_transform(graph, x[i], y[i], xx+i, yy+i);
	
	switch(graph->device) {
		case GDL_GRAPHICS_DEVICE_PS	:
			gdl_graphics2D_draw_path_ps(graph, xx, yy, np, close);
			break;
		case GDL_GRAPHICS_DEVICE_SVG :
			gdl_graphics2D_draw_path_svg(graph, xx, yy, np, close);
			break;
		default :
			break;
	}
	
	GDL_FREE (xx);
	GDL_FREE (yy);
}
/**
 * 
 */
void 
gdl_graphics2D_fill_path(gdl_graphics2D_ptr graph, double *x, double *y, int np)
{
	int i;
	double *xx,*yy;
	
	xx = GDL_CALLOC (double, np);
	yy = GDL_CALLOC (double, np);
	
	for(i=0;i<np;i++)
		gdl_graphics2D_transform(graph, x[i], y[i], xx+i, yy+i);
	
	switch(graph->device) {
		case GDL_GRAPHICS_DEVICE_PS	:
			gdl_graphics2D_fill_path_ps(graph, xx, yy, np);
			break;
		case GDL_GRAPHICS_DEVICE_SVG :
			gdl_graphics2D_fill_path_svg(graph, xx, yy, np);
			break;
		default :
			break;
	}
	
	GDL_FREE (xx);
	GDL_FREE (yy);
} 


