/*  
 *  graphics/svg.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:52 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_graphics.h>


void
gdl_graphics2D_start_svg(gdl_graphics2D_ptr g, double width, double height)
{
   if (g->stream == NULL) return;
   fprintf(g->stream, "<svg width=\"%g\" height=\"%g\" viewBox=\"0,0,%g,%g\" xmlns=\"http://www.w3.org/2000/svg\">\n", width, height, width, height);
}

void gdl_graphics2D_end_svg(gdl_graphics2D_ptr g)
{
   if (g->stream == NULL) return;
   fprintf(g->stream, "</svg>\n");
}
/**
 * 
 */
void
gdl_graphics2D_draw_line_svg(gdl_graphics2D_ptr g, double x1, double y1, double x2, double y2)
{
	if (g->stream == NULL) return;
	
	fprintf(g->stream, "<line x1=\"%g\" y1=\"%g\" x2=\"%g\" y2=\"%g\"", x1, y1, x2, y2);
	fprintf(g->stream, " stroke=\"#%s\" stroke-opacity=\"%g\" stroke-width=\"%g\"", g->color->strhex, g->color->alpha, g->stroke_width);
	if (g->stroke_ndash > 0) {
		// TODO
	}
	fprintf(g->stream, "/>\n");
}
/**
 * 
 */
void
gdl_graphics2D_draw_rect_svg(gdl_graphics2D_ptr g, double x, double y, double width, double height)
{
	if (g->stream == NULL) return;
	
	fprintf(g->stream, "<rect x=\"%g\" y=\"%g\" width=\"%g\" height=\"%g\"", x, y, width, height);
	fprintf(g->stream, " fill=\"none\" stroke=\"#%s\" stroke-opacity=\"%g\" stroke-width=\"%g\"", g->color->strhex, g->color->alpha, g->stroke_width);
	if (g->stroke_ndash > 0) {
		// TODO
	}	
	fprintf(g->stream, "/>\n");
}
/**
 * 
 */
void
gdl_graphics2D_fill_rect_svg(gdl_graphics2D_ptr g, double x, double y, double width, double height)
{
	if (g->stream == NULL) return;
	
	fprintf(g->stream, "<rect x=\"%g\" y=\"%g\" width=\"%g\" height=\"%g\"", x, y, width, height);
	fprintf(g->stream, " fill=\"#%s\"", g->paint->strhex);
	//fprintf(g->stream, " stroke=\"#%s\" stroke-opacity=\"%g\" stroke-width=\"%g\"", g->color->strhex, g->color->alpha, g->stroke_width);
	if (g->stroke_ndash > 0) {
		// TODO
	}	
	fprintf(g->stream, "/>\n");
}
/**
 * 
 */
void
gdl_graphics2D_draw_circle_svg(gdl_graphics2D_ptr g, double x, double y, double r)
{
	if (g->stream == NULL) return;
	
	fprintf(g->stream, "<circle cx=\"%g\" cy=\"%g\" r=\"%g\"", x, y, r);
	fprintf(g->stream, " stroke=\"#%s\" stroke-opacity=\"%g\" stroke-width=\"%g\"", g->color->strhex, g->color->alpha, g->stroke_width);
	if (g->stroke_ndash > 0) {
		// TODO
	}	
	fprintf(g->stream, "/>\n");
}
/**
 * 
 */
void
gdl_graphics2D_fill_circle_svg(gdl_graphics2D_ptr g, double x, double y, double r)
{
	if (g->stream == NULL) return;
	
	fprintf(g->stream, "<circle cx=\"%g\" cy=\"%g\" r=\"%g\"", x, y, r);
	fprintf(g->stream, " fill=\"#%s\"", g->paint->strhex);
	//fprintf(g->stream, " stroke=\"#%s\" stroke-opacity=\"%g\" stroke-width=\"%g\"", g->color->strhex, g->color->alpha, g->stroke_width);
	if (g->stroke_ndash > 0) {
		// TODO
	}	
	fprintf(g->stream, "/>\n");
}
/**
 * 
 * 
 */
void
gdl_graphics2D_draw_path_svg(gdl_graphics2D_ptr g, double *x, double *y, int np, int close)
{
	int len;
	char *pts;
	
	if (g->stream == NULL) return;
	
	pts = gdl_graphics2D_get_strpath2D(x,y,np,&len);
	
	if (!close)
		fprintf(g->stream, "<polyline");
	else
		fprintf(g->stream, "<polygon");
	fprintf(g->stream, " points=\"%s\"", pts);
	fprintf(g->stream, " fill=\"none\" stroke=\"#%s\" stroke-opacity=\"%g\" stroke-width=\"%g\"", g->color->strhex, g->color->alpha, g->stroke_width);
	if (g->stroke_ndash > 0) {
		// TODO
	}	
	fprintf(g->stream, "/>\n");
	
	GDL_FREE (pts);
}
/**
 * 
 * 
 */
void
gdl_graphics2D_fill_path_svg(gdl_graphics2D_ptr g, double *x, double *y, int np)
{
	int len;
	char *pts;
	
	if (g->stream == NULL) return;
	
	pts = gdl_graphics2D_get_strpath2D(x,y,np,&len);
	
	fprintf(g->stream, "<polygon");
	fprintf(g->stream, " points=\"%s\"", pts);
	fprintf(g->stream, " fill=\"%s\"", g->paint->strhex);
	//fprintf(g->stream, " stroke=\"#%s\" stroke-opacity=\"%g\" stroke-width=\"%g\"", g->color->strhex, g->color->alpha, g->stroke_width);
	if (g->stroke_ndash > 0) {
		// TODO
	}	
	fprintf(g->stream, "/>\n");
	
	GDL_FREE (pts);
}
/**
 * 
 * 
 * 
 */
void
gdl_graphics2D_draw_text_svg(gdl_graphics2D_ptr g, double x, double y, const char *text)
{
	if (g->stream == NULL) return;
	if (text == NULL || text[0] == '\0') return;
	
	fprintf(g->stream, "<text");
	fprintf(g->stream, " x=\"%g\" y=\"%g\"", x, y);
	fprintf(g->stream, " font-size=\"%d\"", g->font->size);
	fprintf(g->stream, " fill=\"#%s\"", g->color->strhex);
	fprintf(g->stream, ">\n");
	fprintf(g->stream, "%s\n", text);
	fprintf(g->stream, "</text>\n");
}
