/*  
 *  gstats/distance.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:53 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <math.h>

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_math.h>
#include <gdl/gdl_gstats.h>

double
gdl_gstats_distance_euclidean (const double data1[], const double data2[], const size_t n)
{
	size_t i;
	double t, d = 0;
	
	for (i = 0; i < n; i++)
	{
		if (!gdl_isnan (data1[i]) && !gdl_isnan (data2[i]))
		{
			t  = (data1[i]-data2[i]);
			d += t*t;
		}
	}
	
	return d/n;
}

double
gdl_gstats_distance_kullback_leibler (const double freq1[], const double freq2[], const size_t n)
{
	size_t i;
	double t, d = 0;
	
	for (i = 0; i < n; i++)
	{
		if (!gdl_isnan (freq1[i]) && !gdl_isnan (freq2[i]))
		{
			if (freq1[i] > 0.0 && freq2[i] > 0.0)
			{
				d += freq1[i] * (log (freq1[i]) - log (freq2[i]));
			}
		}
	}
	
	return d;
}

