/*  
 *  gstats/pdiff.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:53 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#include <math.h>

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_math.h>
#include <gdl/gdl_gstats.h>

size_t
gdl_gstats_pairwise_difference (const size_t * haplotype1, const size_t stride1, const size_t * haplotype2, const size_t stride2, const size_t n)
{
	size_t i, d = 0;
	
	for (i = 0; i < n; i++)
	{
		if (haplotype1[i * stride1] != haplotype2[i * stride2])
		{
			d++;
		}
	}
	
	return d;
}

double
gdl_gstats_pairwise_difference_freq (const double * freq1, const size_t stride1, const double * freq2, const size_t stride2, const size_t n)
{
	size_t i;
	double d = 0;
	
	for (i = 0; i < n; i++)
	{
		d += fabs (freq1[i * stride1] - freq2[i * stride2]);
	}
	
	return d;
}
