/*  
 *  gview/clustering.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:43 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_mask.h>
#include <gdl/gdl_gview.h>
#include <gdl/gdl_gview_mask.h>

gdl_clustering *
gdl_gview_accession_clustering (const gdl_gview * g,
                                const gdl_mask * m)
{
	if (g == 0)
		return NULL;
	else
	{
		size_t i, j, n, remain;	
		gdl_boolean * clust;
		gdl_clustering * c;
		gdl_clustering_workspace * w;
		
		n = GDL_GVIEW_ACCESSION_SIZE (g, m);
		
		w = gdl_clustering_workspace_alloc (n);
		
		clust  = GDL_CALLOC (gdl_boolean, n);
		remain = n;
		
		for (i = 0; i < n; i++)
		{
			gdl_accession * a1 = GDL_GVIEW_GET_ACCESSION (g, m, i);
			for (j = i + 1; j < n; j++)
			{
				gdl_accession * a2 = GDL_GVIEW_GET_ACCESSION (g, m, j);
				if (!clust[j])
				{
					if (!GDL_GVIEW_ACCESSION_COMPARE (g, m, i, j))
					{
						clust[j] = gdl_true;
						remain--;
						gdl_clustering_workspace_set (w, i, j);
					}
				}
			}
			if (!remain)
				break;
		}
		
		GDL_FREE (clust);
		
		c = gdl_clustering_workspace_done (w);
		
		return c;
	}
}

