/*  
 * 	gview/collapse.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:43 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_hash.h>
#include <gdl/gdl_gpoint.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_mask.h>
#include <gdl/gdl_gview.h>
#include <gdl/gdl_gview_mask.h>

static gdl_mask * gdl_gview_gmask_collapse_locus (const gdl_gview * g, gdl_mask * m);
static gdl_mask * gdl_gview_gmask_collapse_accession (const gdl_gview * g, gdl_mask * m);

gdl_mask *
gdl_gview_gmask_collapse (const gdl_gview * g,
                                  gdl_mask * m,
                              const gdl_entity_type * type)
{
	if (type == GDL_LOCUS)
	{
		return gdl_gview_gmask_collapse_locus (g, m);
	}
	else if (type == GDL_ACCESSION)
	{
		return gdl_gview_gmask_collapse_accession (g, m);
	}
	else
	{
		return NULL;	
	}
}

static gdl_string *
_key (const gdl_gvalues * xc)
{
	size_t i, len = 0, n;
	gdl_string * tmp;
	gdl_string * key;
	
	for (i = 0; i < xc->size; i++)
	{
		tmp = gdl_string_sprintf ("[%d-%g]", xc->values[i]->idx, xc->values[i]->value);
		len += strlen (tmp);
		gdl_string_free (tmp);
	}
	
	key = gdl_string_alloc (len);
	
	for (n = i = 0; i < xc->size; i++)
	{
		n = gdl_string_scat (&key[n], "[%d-%g]", xc->values[i]->idx, xc->values[i]->value);
	}
	
	return key;
}

static gdl_gvalues *
_lookup (gdl_hashtable * hash, const gdl_gvalues * xc)
{
	gdl_string * key = _key (xc);
	gdl_gvalues * xh = (gdl_gvalues *) gdl_hashtable_lookup (hash, key);
	gdl_string_free (key);
	return xh;
}

static int
_add (gdl_hashtable * hash, const gdl_gvalues * xc, gdl_gvalues * xn)
{
	gdl_string * key = _key (xc);
	int s = gdl_hashtable_add (hash, key, xn, 1);
	gdl_string_free (key);
	return s;
}

static gdl_mask *
gdl_gview_gmask_collapse_locus (const gdl_gview * g, gdl_mask * m)
{
	size_t i, ic, j, na, nl, nc, nn, c;
	gdl_gvalues_get * gbuf;
	const gdl_gvalues * xc;
	gdl_gvalues * xh, * xn;
	gdl_locus * cur, * next;
	gdl_hashtable * hash;
	gdl_mask * u = NULL;	
	
	u = gdl_mask_alloc ();
	
	if (m)
	{
		gdl_mask_set (u, GDL_ACCESSION, gdl_mask_get_clone (m, GDL_ACCESSION), 1);
	}
	
	na = GDL_GVIEW_ACCESSION_SIZE (g, m);
	nl = GDL_GVIEW_LOCUS_SIZE (g, m);
	
	gbuf = GDL_GVIEW_GET_NEW (g, m);
	
	cur = GDL_GVIEW_GET_LOCUS (g, m, 0);
	
	gdl_mask_add (u, cur);
	
	hash = gdl_hashtable_alloc (gdl_gvalues_interface, 0);
	
	nc = gdl_locus_genotype (cur);
	
	for (c = ic = 0, i = 1; i < nl; i++)
	{
		next = GDL_GVIEW_GET_LOCUS (g, m, i);
		
		nn = gdl_locus_genotype (next);
		
		j = 0;
		
		if (nc == nn)
		{
			for (; j < na; j++)
			{
				GDL_GVIEW_GET_GENOTYPE (g, m, j, i, gbuf);
				xn = gdl_gvalues_clone (gdl_gvalues_get_gvalues (gbuf));
				
				GDL_GVIEW_GET_GENOTYPE (g, m, j, ic, gbuf);
				xc  = gdl_gvalues_get_gvalues (gbuf);
				
				if (xn == NULL && xc == NULL)
				{
					continue;
				}
				else if (xn == NULL || xc == NULL)
				{
					gdl_gvalues_free (xn);
					break;
				}
				else
				{
					xh  = _lookup (hash, xc);
					if (xh == NULL)
					{
						_add (hash, xc, xn);
					}
					else if (gdl_gvalues_compare (xn, xh))
					{
						gdl_gvalues_free (xn);
						break;
					}
					else
					{
						gdl_gvalues_free (xn);	
					}
				}
			}			
		}
		if (j < na)
		{
			c  = 0;
			ic = i;
			nc = gdl_locus_genotype (next);
			gdl_hashtable_free (hash);
			hash = gdl_hashtable_alloc (gdl_gvalues_interface, 0);
			// push the locus into the mask
			gdl_mask_add (u, next);
		}
		else
		{
			c++;		
		}
	}	
	
	gdl_gvalues_get_free (gbuf);
	
	return u;
}

static gdl_mask *
gdl_gview_gmask_collapse_accession (const gdl_gview * g,
                                          gdl_mask * m)
{
	return NULL;
}
