/*  
 *  gview/gdl_gview_collector.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:43 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
#ifndef __GDL_GVIEW_COLLECTOR_H__
#define __GDL_GVIEW_COLLECTOR_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_mask.h>
#include <gdl/gdl_gview.h>

__BEGIN_DECLS

typedef enum _gdl_gview_collector_type gdl_gview_collector_type;
typedef struct _gdl_gview_collector gdl_gview_collector;

gdl_gview_collector * gdl_gview_collector_alloc (const gdl_gview_collector_type * T);
void gdl_gview_collector_free (gdl_gview_collector * gc);

gdl_gview_collector * gdl_gview_collector_clone (const gdl_gview_collector * c);
gdl_gview_collector * gdl_gview_collector_fread (FILE * stream);
int gdl_gview_collector_fwrite (FILE * stream, const gdl_gview_collector * c);

int gdl_gview_collector_perform (gdl_gview_collector * gc, const gdl_gview * gd, const gdl_mask * mask, const gdl_clustering * clustering);

size_t gdl_gview_collector_size (const gdl_gview_collector * gc);
size_t gdl_gview_collector_accession_size (const gdl_gview_collector * gc);
size_t gdl_gview_collector_glocus_size (const gdl_gview_collector * gc, size_t r);
size_t gdl_gview_collector_hlocus_size (const gdl_gview_collector * gc, size_t r, size_t h);

size_t gdl_gview_collector_accession_idx (const gdl_gview_collector * gc, size_t r);
size_t gdl_gview_collector_accession_id (const gdl_gview_collector * gc, size_t r);
double gdl_gview_collector_accession_weight (const gdl_gview_collector * gc, size_t r);
const size_t * gdl_gview_collector_glocus_idx (const gdl_gview_collector * gc, size_t r);
const size_t * gdl_gview_collector_hlocus_idx (const gdl_gview_collector * gc, size_t r, size_t h);
gdl_boolean gdl_gview_collector_gcontains (const gdl_gview_collector * gc, size_t r, size_t c);
gdl_boolean gdl_gview_collector_hcontains (const gdl_gview_collector * gc, size_t r, size_t c, size_t h);
int gdl_gview_collector_gset (const gdl_gview_collector * gc, size_t r, size_t l, gdl_gvalues * extra);
int gdl_gview_collector_hset (const gdl_gview_collector * gc, size_t r, size_t h, size_t l, gdl_gvalues * extra);
int gdl_gview_collector_gset_idx (const gdl_gview_collector * gc, size_t ridx, size_t lidx, gdl_gvalues * extra);
int gdl_gview_collector_hset_idx (const gdl_gview_collector * gc, size_t ridx, size_t lidx, size_t p, gdl_gvalues * extra);
gdl_gvalues * gdl_gview_collector_gget (const gdl_gview_collector * gc, size_t r, size_t l);
gdl_gvalues * gdl_gview_collector_hget (const gdl_gview_collector * gc, size_t r, size_t h, size_t l);
gdl_gvalues * gdl_gview_collector_gget_idx (const gdl_gview_collector * gc, size_t ridx, size_t lidx);
gdl_gvalues * gdl_gview_collector_hget_idx (const gdl_gview_collector * gc, size_t ridx, size_t lidx, size_t h);

GDL_VAR const gdl_gview_collector_type * gdl_gview_collector_missing;
GDL_VAR const gdl_gview_collector_type * gdl_gview_collector_heterozygous;

__END_DECLS

#endif /* __GDL_GVIEW_COLLECTOR_H__ */
