/*  
 * 	gview/gdl_gview_mask.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:43 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_GVIEW_MASK_H__
#define __GDL_GVIEW_MASK_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_mask.h>
#include <gdl/gdl_gview.h>

__BEGIN_DECLS

size_t gdl_gview_gmask_accession_size (const gdl_gview * gview, const gdl_mask * mask);
size_t gdl_gview_gmask_locus_size (const gdl_gview * gview, const gdl_mask * mask);
gdl_accession * gdl_gview_gmask_get_accession (const gdl_gview * gview, const gdl_mask * mask, size_t i);
gdl_locus * gdl_gview_gmask_get_locus (const gdl_gview * gview, const gdl_mask * mask, size_t i);
int gdl_gview_gmask_genotype (const gdl_gview * v, const gdl_mask * mask, size_t i, size_t j, gdl_gvalues_get * g);
int gdl_gview_gmask_allele (const gdl_gview * v, const gdl_mask * mask, size_t i, size_t j, size_t k, gdl_gvalues_get * g);
gdl_boolean gdl_gview_gmask_is_homozygous (const gdl_gview * v, const gdl_mask * mask, size_t i, size_t j);
gdl_boolean gdl_gview_gmask_has_missing (const gdl_gview * v, const gdl_mask * mask, size_t i, size_t j);
gdl_boolean gdl_gview_gmask_is_missing (const gdl_gview * v, const gdl_mask * mask, size_t i, size_t j, size_t p);
size_t gdl_gview_gmask_accession_missing_size (const gdl_gview * v, const gdl_mask * mask, size_t i);
size_t gdl_gview_gmask_locus_missing_size (const gdl_gview * v, const gdl_mask * mask, size_t i);
size_t gdl_gview_gmask_gpoint_missing_size (const gdl_gview * v, const gdl_mask * mask, size_t i, size_t j);
int gdl_gview_gmask_genotype_template (const gdl_gview * v, const gdl_mask * m, size_t i, gdl_locus * locus, gdl_gvalues_get * g);
int gdl_gview_gmask_accession_compare (const gdl_gview * v, const gdl_mask * m, size_t i, size_t j);
int gdl_gview_gmask_locus_compare (const gdl_gview * v, const gdl_mask * m, size_t i, size_t j);
gdl_vector * gdl_gview_gmask_genotype_freq (const gdl_gview * v, const gdl_mask * m, size_t l, gdl_gvalues_get * g);
gdl_vector * gdl_gview_gmask_allele_freq (const gdl_gview * v, const gdl_mask * m, size_t l, gdl_gvalues_get * g);

gdl_mask * gdl_gview_gmask_uninformative (const gdl_gview * g, gdl_mask * m, const gdl_entity_type * type);
gdl_mask * gdl_gview_gmask_not_informative_recursive (const gdl_gview * g, const gdl_mask * m);
gdl_mask * gdl_gview_gmask_collapse (const gdl_gview * g, gdl_mask * m, const gdl_entity_type * type);
gdl_mask * gdl_gview_gmask_reverse (const gdl_gview * g, const gdl_mask * m);

size_t GDL_GVIEW_ACCESSION_SIZE (const gdl_gview * gview, const gdl_mask * mask);
size_t GDL_GVIEW_LOCUS_SIZE (const gdl_gview * gview, const gdl_mask * mask);
gdl_accession * GDL_GVIEW_GET_ACCESSION (const gdl_gview * gview, const gdl_mask * mask, size_t i);
gdl_locus * GDL_GVIEW_GET_LOCUS (const gdl_gview * gview, const gdl_mask * mask, size_t i);
gdl_boolean GDL_GVIEW_HAS_MISSING (const gdl_gview * gview, const gdl_mask * mask, size_t i, size_t j);
gdl_boolean GDL_GVIEW_IS_MISSING (const gdl_gview * gview, const gdl_mask * mask, size_t i, size_t j, size_t p);
size_t GDL_GVIEW_ACCESSION_MISSING_SIZE (const gdl_gview * gview, const gdl_mask * mask, size_t i);
size_t GDL_GVIEW_LOCUS_MISSING_SIZE (const gdl_gview * gview, const gdl_mask * mask, size_t i);
size_t GDL_GVIEW_GPOINT_MISSING_SIZE (const gdl_gview * gview, const gdl_mask * mask, size_t i, size_t j);
gdl_boolean GDL_GVIEW_IS_HOMOZYGOUS (const gdl_gview * gview, const gdl_mask * mask, size_t i, size_t j);
gdl_gvalues_get * GDL_GVIEW_GET_NEW (const gdl_gview * gview, const gdl_mask * mask);
int GDL_GVIEW_GET_GENOTYPE (const gdl_gview * gview, const gdl_mask * mask, size_t i, size_t j, gdl_gvalues_get * g);
int GDL_GVIEW_GET_ALLELE (const gdl_gview * gview, const gdl_mask * mask, size_t i, size_t j, size_t k, gdl_gvalues_get * g);
int GDL_GVIEW_GET_GENOTYPE_TEMPLATE (const gdl_gview * gview, const gdl_mask * mask, size_t i, gdl_locus * locus, gdl_gvalues_get * g);
int GDL_GVIEW_ACCESSION_COMPARE (const gdl_gview * gview, const gdl_mask * mask, size_t i, size_t j);
int GDL_GVIEW_LOCUS_COMPARE (const gdl_gview * gview, const gdl_mask * mask, size_t i, size_t j);
gdl_vector * GDL_GVIEW_GENOTYPE_FREQ (const gdl_gview * v, const gdl_mask * m, size_t l, gdl_gvalues_get * g);
gdl_vector * GDL_GVIEW_ALLELE_FREQ (const gdl_gview * v, const gdl_mask * m, size_t l, gdl_gvalues_get * g);


typedef struct
{
	gdl_string * name;
	gdl_mask * (*next) (const gdl_gview * g, const gdl_mask * m, size_t * l, size_t smax);
} gdl_gview_gmask_type;

typedef struct _gdl_gview_gmask_itr gdl_gview_gmask_itr;

gdl_gview_gmask_itr * gdl_gview_gmask_iterator (const gdl_gview * g, const gdl_mask * m, const gdl_gview_gmask_type * type, size_t smax);
int gdl_gview_gmask_iterator_next (gdl_gview_gmask_itr * itr);
gdl_mask * gdl_gview_gmask_iterator_value(gdl_gview_gmask_itr * itr);
void gdl_gview_gmask_iterator_free (gdl_gview_gmask_itr * itr);

GDL_VAR const gdl_gview_gmask_type * gdl_gview_gmask_heterozygous;

__END_DECLS

#endif
