/*  
 * 	gview/gdl_gview_writer.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:43 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_GVIEW_WRITER_H__
#define __GDL_GVIEW_WRITER_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_gview.h>
#include <gdl/gdl_gview_wrapper.h>

__BEGIN_DECLS

typedef struct _gdl_gview_writer gdl_gview_writer;

typedef struct
{
	char * missing;
	int (*write)(FILE * stream, const gdl_gview * gview);
	int (*write_wrapper)(FILE * stream, const gdl_gview_wrapper * gwrap);
} gdl_gview_writer_type;

gdl_gview_writer_type * gdl_gview_writer_type_new (const gdl_gview_writer_type * type);
void gdl_gview_writer_type_free (gdl_gview_writer_type * type);
void gdl_gview_writer_type_missing (gdl_gview_writer_type * t, gdl_string * missing);

struct _gdl_gview_writer
{
	gdl_string * filename;
	gdl_string * error;
	FILE       * stream;
	gdl_gview_writer_type * type;	
};

// High level api
gdl_gview_writer * gdl_gview_writer_alloc (gdl_gview_writer_type * type);
void gdl_gview_writer_free (gdl_gview_writer * writer);
int gdl_gview_writer_open (gdl_gview_writer * writer, const gdl_string * filename);
int gdl_gview_writer_dump (gdl_gview_writer * writer, const gdl_gview * gview);
int gdl_gview_writer_wrapper_dump (gdl_gview_writer * writer, const gdl_gview_wrapper * gview);
int gdl_gview_writer_close (gdl_gview_writer * writer);
// Low level api
int gdl_gview_writer_error (gdl_gview_writer * writer, char * format, ...);

GDL_VAR const gdl_gview_writer_type * gdl_gview_writer_standard;

__END_DECLS

#endif /* __GDL_GVIEW_WRITER_H__ */
