/*  
 * 	gview/test.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:43 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_io.h>
#include <gdl/gdl_util.h>
#include <gdl/gdl_test.h>
#include <gdl/gdl_clustering.h>
#include <gdl/gdl_mask.h>
#include <gdl/gdl_gview.h>
#include <gdl/gdl_gview_mask.h>
#include <gdl/gdl_gview_collector.h>
#include <gdl/gdl_gview_wrapper.h>
#include <gdl/gdl_gview_reader.h>
#include <gdl/gdl_gview_writer.h>

gdl_gview_reader_type *
test_type_1 (void)
{
	gdl_gview_reader_type * type =
    	gdl_gview_reader_type_new (gdl_gview_reader_standard);
    
    gdl_gview_reader_type_missing (type, "missing");    
    
    return type;
}

gdl_gview_reader_type *
test_type_2 (void)
{
	gdl_gview_reader_type * type =
    	gdl_gview_reader_type_new (gdl_gview_reader_standard);
    
    gdl_gview_reader_type_missing (type, "0");
    gdl_gview_reader_type_name_separator (type, " ");
    gdl_gview_reader_type_data_separator (type, " ");
    gdl_gview_reader_type_ploidy (type, 2);
    gdl_gview_reader_type_locus_name (type, gdl_false);
    gdl_gview_reader_type_is_phased (type, gdl_false);
    
    return type;
}


gdl_gview_reader_type *
test_type_3 (void)
{
	gdl_gview_reader_type * type =
    	gdl_gview_reader_type_new (gdl_gview_reader_standard);
    
    gdl_gview_reader_type_missing (type, "N");
    gdl_gview_reader_type_data_separator (type, "");
    gdl_gview_reader_type_name_separator (type, " ");
    gdl_gview_reader_type_locus_name (type, gdl_false);
    
    return type;
}

gdl_gview_reader_type *
test_type_4 (void)
{
	gdl_gview_reader_type * type =
    	gdl_gview_reader_type_new (gdl_gview_reader_standard);
    
    gdl_gview_reader_type_missing (type, "N");
    gdl_gview_reader_type_data_separator (type, "");
    gdl_gview_reader_type_name_separator (type, " ");
    gdl_gview_reader_type_locus_name (type, gdl_false);
    
    return type;
}

int
test_parse_1 (void)
{
	size_t i, j;
	FILE * stream;
	gdl_gview_reader_type * type;
	gdl_gview_reader      * reader;
	//gdl_gview_writer_type * wtype;
	gdl_gview_writer      * writer;
	gdl_gview * v;
	gdl_gview_collector * c;
	gdl_clustering * clust;
	gdl_mask * m , * u;
	
	type = test_type_1 ();
	
	reader = gdl_gview_reader_alloc (type);
		
	gdl_gview_reader_open (reader, "examples/gdata1.txt");
	
	v = gdl_gview_reader_parse (reader);
	
	gdl_gview_reader_close (reader);
	
	gdl_gview_reader_free (reader);
	
//	c = gdl_gview_collector_alloc (gdl_gview_collector_missing);
//	
//	u = gdl_gview_gmask_uninformative (v, NULL, GDL_LOCUS);
//	
//	m = gdl_gview_gmask_uninformative (v, u, GDL_ACCESSION);
//	
//	clust = gdl_gview_accession_clustering (v, m);
//	
//	gdl_gview_collector_perform (c, v, m, clust);
//	
//	for (i = 0; i < gdl_gview_collector_accession_size (c); i++)
//	{
//		size_t idx = gdl_gview_collector_accession_idx (c, i);
//		idx = gdl_clustering_clust_idx (clust, idx);
//		size_t nm  = gdl_gview_collector_glocus_size (c, i);
//		const size_t * gidx = gdl_gview_collector_glocus_idx (c, i);
//		gdl_accession * a = GDL_GVIEW_GET_ACCESSION (v, m, idx);
//		double x = 2;
//		
//		printf ("MISSING %s", a->name);
//		for (j = 0; j < nm; j++)
//		{
//			printf (" %d", gidx[j]);
//			gdl_gview_collector_hset (c, i, 0, j, &x);
//			double * y = (double * ) gdl_gview_collector_hget (c, i, 0, j);
//			printf (" (%g)", *y);
//		}
//		printf ("\n");
//	}
//	
//	gdl_gview_collector_free (c);
	
    stream = gdl_fileopen ("test.dat", "w");
	
	gdl_gview_fwrite (stream, v);
	
	gdl_fileclose ("test.dat", stream);
	
	gdl_gview_free (v);
	
	stream = gdl_fileopen ("test.dat", "r");
	
	v = gdl_gview_fread (stream);
	
	gdl_fileclose ("test.dat", stream);
	
	writer = gdl_gview_writer_alloc (gdl_gview_writer_type_new (gdl_gview_writer_standard));
	
	gdl_gview_writer_open (writer, "test.txt");
	
	gdl_gview_writer_dump (writer, v);
	
	gdl_gview_writer_close (writer);
	
	gdl_gview_writer_free (writer);

	gdl_gview_free (v);
}

int
test_parse_2 (void)
{
	size_t i, j, k;
	FILE * stream;
	gdl_gview_reader_type * type;
	gdl_gview_reader      * reader;
	gdl_gview_writer      * writer;
	gdl_gview * v;
	gdl_gvalues_get * x;
	
//	type = test_type_2 ();
//	
//	reader = gdl_gview_reader_alloc (type);
//		
//	gdl_gview_reader_open (reader, "examples/gdata2.txt");
//	
//	v = gdl_gview_reader_parse (reader);
//	
//	gdl_gview_reader_close (reader);
//	
//	gdl_gview_reader_free (reader);
//	
//    stream = gdl_fileopen ("test.dat", "w");
//	
//	gdl_gview_fwrite (stream, v);
//	
//	gdl_fileclose ("test.dat", stream);
//	
//	gdl_gview_free (v);
	
	stream = gdl_fileopen ("test.dat", "r");
	
	v = gdl_gview_fread (stream);
	
	gdl_fileclose ("test.dat", stream);
//	
//	writer = gdl_gview_writer_alloc (gdl_gview_writer_type_new (gdl_gview_writer_standard));
//	
//	gdl_gview_writer_open (writer, "test.txt");
//	
//	gdl_gview_writer_dump (writer, v);
//	
//	gdl_gview_writer_close (writer);
//	
//	gdl_gview_writer_free (writer);
	
	gdl_gview_free (v);
}

int
test_parse_3 (void)
{
	size_t i, j;
	FILE * stream;
	gdl_clustering * clust;
	gdl_gview_collector * c;
	gdl_mask * m, * u;
	gdl_gview_reader_type * type;
	gdl_gview_reader      * reader;
	gdl_gview_writer      * writer;
	gdl_gview * v;
	
	type = test_type_3 ();
	
	reader = gdl_gview_reader_alloc (type);
		
	gdl_gview_reader_open (reader, "examples/gdata3.txt");
	
	v = gdl_gview_reader_parse (reader);
	
	gdl_gview_reader_close (reader);
	
	gdl_gview_reader_free (reader);
	
//	c = gdl_gview_collector_alloc (gdl_gview_collector_missing);
//	
//	u = gdl_mask_uninformative (v, NULL, GDL_LOCUS);
//	
//	m = gdl_mask_uninformative (v, u, GDL_ACCESSION);
//	
//	clust = gdl_gview_accession_clustering (v, m);
//	
//	gdl_gview_collector_perform (c, v, m, clust);
//	
//	gdl_gview_collector_free (c);
	
    stream = gdl_fileopen ("test.dat", "w");
	
	gdl_gview_fwrite (stream, v);
	
	gdl_fileclose ("test.dat", stream);
	
	gdl_gview_free (v);
//	
//	stream = gdl_fileopen ("test.dat", "r");
//	
//	v = gdl_gview_fread (stream);
//	
//	gdl_fileclose ("test.dat", stream);
//	
//	writer = gdl_gview_writer_alloc (gdl_gview_writer_type_new (gdl_gview_writer_standard));
//	
//	gdl_gview_writer_open (writer, "test.txt");
//	
//	gdl_gview_writer_dump (writer, v);
//	
//	gdl_gview_writer_close (writer);
//	
//	gdl_gview_writer_free (writer);
//
//	gdl_gview_free (v);
}

int
test_parse_4 (void)
{
	size_t i, j;
	FILE * stream;
	gdl_clustering * clust;
	gdl_gview_collector * c;
	gdl_mask * m, * u;
	gdl_gview_reader_type * type;
	gdl_gview_reader      * reader;
	gdl_gview_writer      * writer;
	gdl_gview * v;
	
	type = test_type_3 ();
	
//	reader = gdl_gview_reader_alloc (type);
//		
//	gdl_gview_reader_open (reader, "examples/gdata3.txt");
	
	stream = gdl_fileopen ("test.dat", "r");
	
	v = gdl_gview_fread (stream);
	
	gdl_fileclose ("test.dat", stream);
	
//	gdl_gview_reader_close (reader);
//	
//	gdl_gview_reader_free (reader);
	
	m = gdl_gview_gmask_collapse (v, NULL, GDL_LOCUS);
	
	if (m) {
		printf ("NLOCUS %d\n", gdl_mask_get_size (m, GDL_LOCUS));
		gdl_mask_free (m);
	}
	
	gdl_gview_free (v);
}

int
test_parse (void)
{
	size_t i = 0;
	test_parse_2 ();
	//test_parse_2 ();
	//test_parse_3 ();
	//test_parse_4 ();
}

int 
test_wrapper (void)
{
	gdl_mask * gmask, * u;
	gdl_gview_reader_type * type;
	gdl_gview_reader      * reader;
	gdl_gview             * gview;
	gdl_gview_wrapper     * gwrap; 
	
	type = test_type_2 ();
	
	reader = gdl_gview_reader_alloc (type);
		
	gdl_gview_reader_open (reader, "examples/gdata2.txt");
	
	gview = gdl_gview_reader_parse (reader);
	
	gdl_gview_reader_close (reader);
	
	gdl_gview_reader_free (reader);
	
	u = gdl_gview_gmask_uninformative (gview, NULL, GDL_LOCUS);
	gmask = gdl_gview_gmask_uninformative (gview, u, GDL_ACCESSION);
	
	gwrap = gdl_gview_wrapper_alloc (gdl_gview_wrapper_local, gview, gmask);
	
	gdl_gview_wrapper_free (gwrap);
	gdl_mask_free (gmask);
	gdl_gview_free (gview);
}

int
test_virtual (void)
{
	size_t i, j;
	FILE * stream;
	gdl_clustering * clust;
	gdl_gview_collector * c;
	gdl_mask * m, * u;
	gdl_gview_reader_type * type;
	gdl_gview_reader      * reader;
	gdl_gview_writer      * writer;
	gdl_gview * g1, * g2, * g3, * v;
	
	type = test_type_1 ();
	
	reader = gdl_gview_reader_alloc (type);
		
	gdl_gview_reader_open (reader, "examples/gdata1.txt");
	
	g1 = gdl_gview_reader_parse (reader);
		
	gdl_gview_reader_close (reader);
	
	gdl_gview_reader_open (reader, "examples/gdata1.txt");
	
	g2 = gdl_gview_reader_parse (reader);
	
	gdl_gview_reader_close (reader);
	
	gdl_gview_reader_open (reader, "examples/gdata1.txt");
	
	g3 = gdl_gview_reader_parse (reader);
	
	gdl_gview_reader_close (reader);
	
	gdl_gview_reader_free (reader);
	
	v = gdl_gview_alloc (gdl_gview_virtual);
	
	gdl_gview_init (v, 0, 0, gdl_gview_ploidy (g1));
	
	gdl_gview_add (v, "G1", g1, 1);
	gdl_gview_add (v, "G2", g2, 1);
	gdl_gview_add (v, "G3", g3, 1);
	
	writer = gdl_gview_writer_alloc (gdl_gview_writer_type_new (gdl_gview_writer_standard));
	
	gdl_gview_writer_open (writer, "test.txt");
	
	gdl_gview_writer_dump (writer, v);
	
	gdl_gview_writer_close (writer);
	
	stream = gdl_fileopen ("test.dat", "w");
	
	gdl_gview_fwrite (stream, v);
	
	gdl_fileclose ("test.dat", stream);
	
	gdl_gview_free (v);
	
	stream = gdl_fileopen ("test.dat", "r");
	
	v = gdl_gview_fread (stream);
	
	gdl_fileclose ("test.dat", stream);
	
	gdl_gview_writer_open (writer, "test.txt_1");
	
	gdl_gview_writer_dump (writer, v);
	
	gdl_gview_writer_close (writer);
	
	gdl_gview_writer_free (writer);
	
	gdl_gview_free (v);
}

int
main (void)
{
	test_virtual ();
	exit (gdl_test_summary());
}
