/*  
 * 	gview/unit.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:43 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
#include <string.h>
 
#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_io.h>
#include <gdl/gdl_gpoint.h>
#include <gdl/gdl_gview.h>
#include <gdl/gdl_gview_reader.h>

gdl_gview_reader_gpoint *
gdl_gview_reader_gpoint_alloc (size_t n)
{
	size_t i;
	gdl_gview_reader_gpoint * u;
	
	u = GDL_MALLOC (gdl_gview_reader_gpoint, 1);
	
	if (u == 0)
	{
		GDL_ERROR_VAL ("Unable to allocate memory in gdl_gview_reader_gpoint",
		               GDL_ENOMEM,
		               0);
	}
	
	u->n       = n;
	u->alleles = GDL_MALLOC (char *, n);
	
	if (u->alleles == 0)
	{
		GDL_FREE (u);
		GDL_ERROR_VAL ("Unable to allocate memory in gdl_gview_reader_gpoint",
		               GDL_ENOMEM,
		               0);
	}
	
	u->recessives = GDL_MALLOC (size_t, n);
	
	for (i = 0; i < n; i++)
	{
		u->alleles[i]    = NULL;
		u->recessives[i]  = 0;
	}
	
	u->idx     = 0;
	u->value   = 0.;
	
	
	return u;
}

static void
gdl_gview_reader_gpoint_free (gdl_gview_reader_gpoint * u)
{
	if (u)
	{
		if (u->alleles)
		{
			size_t i;
			for (i = 0; i < u->n; i++)
			{
				GDL_FREE (u->alleles[i]);
			}
			GDL_FREE (u->alleles);
		}
		GDL_FREE (u->recessives);
		GDL_FREE (u);
	}	
}

static void
_gdl_gview_reader_gpoint_free (void * vr)
{
	gdl_gview_reader_gpoint * r = 	(gdl_gview_reader_gpoint *) vr;
	gdl_gview_reader_gpoint_free (r);
}

static gdl_data_interface _gdl_gview_reader_gpoint_interface =
{
	&_gdl_gview_reader_gpoint_free,
	NULL,
	NULL,
	NULL,
	NULL
};

static const gdl_data_interface * gdl_gview_reader_gpoint_interface = &_gdl_gview_reader_gpoint_interface;
