/*  
 * 	hmap/fread.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:45 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_mask.h>
#include <gdl/gdl_gview.h>
#include <gdl/gdl_gview_mask.h>
#include <gdl/gdl_hview.h>
#include <gdl/gdl_gmap.h>
#include <gdl/gdl_hmap.h>

int
gdl_hmap_fread (FILE * stream, gdl_hmap * h)
{
	if (stream && h)
	{
		size_t i, j;
		int status;
		
		status = fread (&h->ng, sizeof(size_t), 1, stream);
		GDL_FWRITE_STATUS (status, 1);
		status = fread (&h->nc, sizeof(size_t), h->ng, stream);
		GDL_FWRITE_STATUS (status, h->ng);
		
		for (i = 0; i < h->ng; i++)
		{
			for (j = 0; j < h->nc[i]; j++)
			{
				h->hmask[i][j] = gdl_mask_fread (stream);
				GDL_FREAD_STATUS (h->hmask[i][j] != 0, 1);
				h->hdata[i][j] = gdl_hview_alloc (h->data, h->hmask[i][j]);
				status = gdl_hview_fread (stream, h->hdata[i][j]);
				GDL_FREAD_STATUS (h->hdata[i][j] != 0, 1);
			}
		}
		
		return GDL_SUCCESS;
	}
	else
	{
		return GDL_EINVAL;
	}
}

int
gdl_hmap_fwrite (FILE * stream, const gdl_hmap * h)
{
	if (stream && h)
	{
		size_t i, j;
		int status;
		
		status = fwrite (&h->ng, sizeof(size_t), 1, stream);
		GDL_FWRITE_STATUS (status, 1);
		status = fwrite (&h->nc, sizeof(size_t), h->ng, stream);
		GDL_FWRITE_STATUS (status, h->ng);
		
		for (i = 0; i < h->ng; i++)
		{
			for (j = 0; j < h->nc[i]; j++)
			{
				status = gdl_mask_fwrite (stream, h->hmask[i][j]);
				GDL_FREAD_STATUS (status, GDL_SUCCESS);
				status = gdl_hview_fwrite (stream, h->hdata[i][j]);
				GDL_FREAD_STATUS (status, GDL_SUCCESS);
			}
		}
		
		return GDL_SUCCESS;
	}
	else
	{
		return GDL_EINVAL;
	}
}
