/*  
 * 	hmap/test.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:45 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_io.h>
#include <gdl/gdl_util.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_test.h>
#include <gdl/gdl_clustering.h>
#include <gdl/gdl_gmap.h>
#include <gdl/gdl_mask.h>
#include <gdl/gdl_gview.h>
#include <gdl/gdl_gview_mask.h>
#include <gdl/gdl_hview.h>
#include <gdl/gdl_gview_reader.h>
#include <gdl/gdl_gmap_reader.h>
#include <gdl/gdl_hmap.h>

gdl_gview_reader_type *
_reader_type (size_t t)
{
	gdl_gview_reader_type * type =
    	gdl_gview_reader_type_new (gdl_gview_reader_standard);
    
    switch (t)
    {
    	case 1 :
    		gdl_gview_reader_type_missing (type, "missing");
    		return type;
    	case 2 :
		    gdl_gview_reader_type_missing (type, "0");
		    gdl_gview_reader_type_nfsep (type, " ");
		    gdl_gview_reader_type_gfsep (type, " ");
		    gdl_gview_reader_type_ploidy (type, 2);
		    gdl_gview_reader_type_locus_name (type, gdl_true);
		    gdl_gview_reader_type_is_phased (type, gdl_false);
    		return type;
    	case 3 :
		    gdl_gview_reader_type_missing (type, "0");
		    gdl_gview_reader_type_nfsep (type, " ");
		    gdl_gview_reader_type_gfsep (type, " ");
		    gdl_gview_reader_type_ploidy (type, 2);
		    gdl_gview_reader_type_locus_name (type, gdl_true);
		    gdl_gview_reader_type_is_phased (type, gdl_false);
    		return type;
    	case 4 :
    		gdl_gview_reader_type_missing (type, "N");
		    gdl_gview_reader_type_nfsep (type, " ");
		    gdl_gview_reader_type_gfsep (type, "");
		    gdl_gview_reader_type_ploidy (type, 1);
		    gdl_gview_reader_type_locus_name (type, gdl_true);
    		return type;
    }
}

gdl_gview *
_read_data (size_t t)
{
	size_t i, j;
	FILE * stream;
	gdl_string * file;
	gdl_gview_reader_type * type;
	gdl_gview_reader      * reader;
	gdl_gview * v;
	
	type = _reader_type (t);
	
	reader = gdl_gview_reader_alloc (type);
	
	file = gdl_string_sprintf ("examples/data%d.txt", t);
	
	gdl_gview_reader_open (reader, file);
	
	v = gdl_gview_reader_parse (reader);
	
	gdl_gview_reader_close (reader);
	
	gdl_gview_reader_free (reader);
	
	gdl_string_free (file);
	
	return v;	
}

gdl_gmap *
_read_map (size_t t)
{
	size_t i, j;
	FILE * stream;
	gdl_string * file;
	gdl_gmap_reader * reader;
	gdl_gmap * map;
	
	reader = gdl_gmap_reader_alloc (gdl_gmap_reader_absolute);
	
	file = gdl_string_sprintf ("examples/map%d.txt", t);
	
	gdl_gmap_reader_open (reader, file);
	
	map = gdl_gmap_reader_parse (reader);
	
	if (map==0)
	{
		fprintf (stderr, "[ ERROR ] %s", reader->error);
		exit (1);	
	}
	
	gdl_gmap_reader_close (reader);
	
	gdl_gmap_reader_free (reader);
	
	gdl_string_free (file);
	
	return map;	
}

int
test_create (size_t t)
{
	size_t i, ii, j, k, ng, nc;
	gdl_gview * g;
	gdl_gmap * gm;
	gdl_mask * m = NULL;
	gdl_mask * u;
	gdl_hmap * hmap;
	gdl_clustering * gclust;
	
	g  = _read_data (t);
	
	gm = _read_map (t);
	
	u = gdl_gview_gmask_uninformative (g, NULL, GDL_LOCUS);
	
	m = gdl_gview_gmask_uninformative (g, u, GDL_ACCESSION);
	
	gdl_mask_free (u);
	
	gm = gdl_gview_extract_gmap (g, m, gm);
	
	hmap = gdl_hmap_create (g, m, gm);
	
	gdl_hmap_free (hmap);
	
	gdl_gview_free (g);
	
	gdl_gmap_free (gm);
	
	return GDL_SUCCESS;
}

int
main (void)
{
    test_create (3);	
	exit (gdl_test_summary());
}
