/*  
 *  hsmap/gdl_hsmap_model.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:44 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_HSMAP_MODEL_H__
#define __GDL_HSMAP_MODEL_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_rng.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_mask.h>
#include <gdl/gdl_gview.h>
#include <gdl/gdl_hview.h>
#include <gdl/gdl_hmap.h>
#include <gdl/gdl_fview_wrapper.h>
#include <gdl/gdl_view.h>
#include <gdl/gdl_hstruct_model.h>
#include <gdl/gdl_hstruct_result.h>
#include <gdl/gdl_hsmap_partition.h>
#include <gdl/gdl_hsmap_position.h>

__BEGIN_DECLS

typedef struct _gdl_hsmap_model gdl_hsmap_model;

typedef struct 
{
	size_t N;
	size_t M;
	size_t df;
	size_t df1;
	double rsq;
	double rsq1;
	double log;
	double fstat;
	double pval;
	gdl_vector * c;
	gdl_vector * sd;
} gdl_hsmap_model_result;

typedef struct
{
	size_t N;
	size_t M;
	size_t no;
	size_t nl;
	size_t trait;
 	size_t * other;
 	size_t * locus;
 	gdl_hsmap_model_result * result;
} gdl_hsmap_static_model;

gdl_hsmap_model * gdl_hsmap_model_alloc (gdl_hsmap_partition ** partitions, size_t np, const gdl_fview_wrapper * tdata, size_t t, const gdl_fview_wrapper * odata);

size_t gdl_hsmap_model_partition_size (const gdl_hsmap_model * model);
gdl_hsmap_position * gdl_hsmap_model_new_ancestral_position (const gdl_hsmap_model * model, size_t p, size_t l, double position);
gdl_hsmap_position * gdl_hsmap_model_new_locus_position (const gdl_hsmap_model * model, size_t p, size_t l);
gdl_hsmap_position * gdl_hsmap_model_new_mutation_position (const gdl_hsmap_model * model, size_t p, size_t l, double position, size_t k);

size_t gdl_hsmap_model_add_eligible (gdl_hsmap_model * model, gdl_hsmap_position * position);
gdl_hsmap_position * gdl_hsmap_model_rmv_eligible (gdl_hsmap_model * model, size_t i);
size_t gdl_hsmap_model_keep_eligible (gdl_hsmap_model * model, size_t i);

const gdl_hsmap_model_result * gdl_hsmap_model_eval (gdl_hsmap_model * m);

int gdl_hsmap_model_fprintf (FILE * stream, const gdl_hsmap_model * model);

__END_DECLS

#endif
