/*  
 *  hsmap/gdl_hsmap_position.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:44 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_HSMAP_POSITION_H__
#define __GDL_HSMAP_POSITION_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_rng.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_matrix.h>
#include <gdl/gdl_hsmap_partition.h>

__BEGIN_DECLS

enum _gdl_hsmap_position_type
{
	GDL_HSMAP_POSITION_ANCESTRAL,
	GDL_HSMAP_POSITION_LOCUS,
	GDL_HSMAP_POSITION_MUTATION
};

typedef enum _gdl_hsmap_position_type gdl_hsmap_position_type;

typedef struct gdl_hsmap_position
{
	const gdl_hsmap_position_type * type;
	const gdl_locus * locus;
	size_t locus_idx;
	double position;
	gdl_matrix * data;
} gdl_hsmap_position;

typedef struct _gdl_hsmap_position_model gdl_hsmap_position_model;

gdl_hsmap_position * gdl_hsmap_position_alloc (const gdl_hsmap_position_type * T);
void gdl_hsmap_position_free (gdl_hsmap_position * p);

int gdl_hsmap_position_init (gdl_hsmap_position * p, size_t i, double x, const gdl_hsmap_partition * partition, const gdl_mask * mask, void * extra);
gdl_boolean gdl_hsmap_position_is_missing (const gdl_hsmap_position * p, size_t i);

gdl_hsmap_position_model * gdl_hsmap_position_model_alloc (void);
void gdl_hsmap_position_model_free (gdl_hsmap_position_model * m);
size_t gdl_hsmap_position_model_size (const gdl_hsmap_position_model * m);
size_t gdl_hsmap_position_model_column_size (const gdl_hsmap_position_model * m);
size_t gdl_hsmap_position_model_add (gdl_hsmap_position_model * m, gdl_hsmap_position * p);
gdl_hsmap_position * gdl_hsmap_position_model_remove (gdl_hsmap_position_model * m, size_t i);
gdl_hsmap_position * gdl_hsmap_position_model_get (const gdl_hsmap_position_model * m, size_t i);
 
GDL_VAR const gdl_hsmap_position_type * gdl_hsmap_position_ancestral;
GDL_VAR const gdl_hsmap_position_type * gdl_hsmap_position_locus;
GDL_VAR const gdl_hsmap_position_type * gdl_hsmap_position_mutation;

__END_DECLS

#endif
