/* 
 * hsmap/gdl_hsmap_result.h
 * 
 * Copyright (C) 2006 Jean-Baptiste Veyrieras
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GDL_HSMAP_RESULT_H__
#define __GDL_HSMAP_RESULT_H__

#include <stdio.h>

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_math.h>
#include <gdl/gdl_odb.h>
#include <gdl/gdl_hsmap.h>

__BEGIN_DECLS

typedef struct _gdl_hsmap_result gdl_hsmap_result;

gdl_hsmap_result * gdl_hsmap_result_alloc (gdl_hsmap_workspace * w);
void gdl_hsmap_result_free (gdl_hsmap_result * r);

size_t gdl_hsmap_result_size (const gdl_hsmap_result * r);

gdl_hsmap_result * gdl_hsmap_result_fread (FILE * stream);
int gdl_hsmap_result_fwrite (FILE * stream, const gdl_hsmap_result * r);
int gdl_hsmap_result_fprintf (FILE * stream, const gdl_hsmap_result * r);

GDL_VAR const gdl_odriver * gdl_hsmap_result_driver;

__END_DECLS

#endif

