/*  
 *  hstruct/gdl_hstruct_block.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:44 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_HSTRUCT_BLOCK_H__
#define __GDL_HSTRUCT_BLOCK_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_matrix.h>
#include <gdl/gdl_vector.h>
#include <gdl/gdl_hmap.h>
#include <gdl/gdl_hstruct.h>

__BEGIN_DECLS

typedef struct
{
	size_t k;
	size_t from;
	size_t to;
	gdl_matrix      * left;
	gdl_matrix      * right;
	gdl_vector_uint * best;
} gdl_hstruct_block;

gdl_hstruct_block * gdl_hstruct_block_alloc (size_t kmax, size_t k, size_t from, size_t to, const gdl_matrix * left, const gdl_matrix * right);
void gdl_hstruct_block_free (gdl_hstruct_block * b);
gdl_hstruct_block * gdl_hstruct_block_fread (FILE * stream);
int gdl_hstruct_block_fwrite (FILE * stream, const gdl_hstruct_block * b);

typedef struct
{
	size_t size;
	size_t kmax;
	gdl_hstruct_block ** blocks;
} gdl_hstruct_block_partition;

gdl_hstruct_block_partition * gdl_hstruct_block_partition_alloc (const gdl_hstruct_model_partition * p);
void gdl_hstruct_block_partition_free (gdl_hstruct_block_partition * bp);
size_t gdl_hstruct_block_partition_kmax (const gdl_hstruct_block_partition * bp);
size_t gdl_hstruct_block_partition_size (const gdl_hstruct_block_partition * bp);
gdl_hstruct_block * gdl_hstruct_block_partition_get (const gdl_hstruct_block_partition * bp, size_t i);

gdl_hstruct_block_partition * gdl_hstruct_block_partition_fread (FILE * stream);
int gdl_hstruct_block_partition_fwrite (FILE * stream, const gdl_hstruct_block_partition * b);

__END_DECLS

#endif
