/*  
 * 	hstruct/gdl_hstruct_criterion.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:44 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_HSTRUCT_CRITERION_H__
#define __GDL_HSTRUCT_CRITERION_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_hstruct_model.h>

__BEGIN_DECLS

typedef struct 
{
	gdl_string * name;
	gdl_string * acronym;
	double (*value)(const gdl_hstruct_model * model);
} gdl_hstruct_criterion_type;

double gdl_hstruct_criterion_eval (const gdl_hstruct_criterion_type * c, const gdl_hstruct_model * model);

GDL_VAR const gdl_hstruct_criterion_type * gdl_hstruct_criterion_AIC;
GDL_VAR const gdl_hstruct_criterion_type * gdl_hstruct_criterion_BIC;

__END_DECLS

#endif
