/*  
 * 	hstruct/gdl_hstruct_data.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:44 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_HSTRUCT_DATA_H__
#define __GDL_HSTRUCT_DATA_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_gblock.h>
#include <gdl/gdl_gpoint.h>
#include <gdl/gdl_rng.h>
#include <gdl/gdl_clustering.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_locus_type.h>
#include <gdl/gdl_mask.h>
#include <gdl/gdl_gview.h>
#include <gdl/gdl_hview.h>
#include <gdl/gdl_view.h>

__BEGIN_DECLS

typedef struct
{
	const gdl_view  * view;
	const gdl_gview * gview;
	const gdl_mask * gmask;
	const gdl_clustering * gclust;
	const gdl_chromosome * chrom;
	const gdl_rng * rng;
	const gdl_locus_type_registry * locus_type;
	gdl_gmap  * gmap;
} gdl_hstruct_data;

gdl_hstruct_data * gdl_hstruct_data_alloc (void);
void gdl_hstruct_data_free (gdl_hstruct_data * data);

void gdl_hstruct_data_set_gview (gdl_hstruct_data * d, const gdl_gview * g);
void gdl_hstruct_data_set_gmask (gdl_hstruct_data * d, const gdl_mask * g);
void gdl_hstruct_data_set_gclust (gdl_hstruct_data * d, const gdl_clustering * g);
void gdl_hstruct_data_set_chrom (gdl_hstruct_data * d, const gdl_chromosome * g);
void gdl_hstruct_data_set_rng (gdl_hstruct_data * d, const gdl_rng * rng);
void gdl_hstruct_data_set_locus_type (gdl_hstruct_data * d, const gdl_locus_type_registry * locus_type);

const gdl_view * gdl_hstruct_data_get_view (gdl_hstruct_data * d);
const gdl_gview * gdl_hstruct_data_get_gview (gdl_hstruct_data * d);
const gdl_gmap * gdl_hstruct_data_get_gmap (gdl_hstruct_data * d);
const gdl_mask * gdl_hstruct_data_get_gmask (gdl_hstruct_data * d);
const gdl_clustering * gdl_hstruct_data_get_gclust (gdl_hstruct_data * d);
const gdl_rng * gdl_hstruct_data_get_rng (gdl_hstruct_data * d);
const gdl_locus_type_registry * gdl_hstruct_data_get_locus_type (const gdl_hstruct_data * d);

size_t gdl_hstruct_data_size (gdl_hstruct_data * d);

__END_DECLS

#endif
