/*  
 *  hstruct/gdl_hstruct_fuzzy.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:44 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_HSTRUCT_FUZZY_H__
#define __GDL_HSTRUCT_FUZZY_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_gblock.h>
#include <gdl/gdl_gpoint.h>
#include <gdl/gdl_rng.h>
#include <gdl/gdl_clustering.h>
#include <gdl/gdl_allele_block.h>
#include <gdl/gdl_vector.h>
#include <gdl/gdl_matrix.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_gview_wrapper.h>

__BEGIN_DECLS

typedef struct _gdl_hstruct_fuzzy gdl_hstruct_fuzzy;

gdl_hstruct_fuzzy * gdl_hstruct_fuzzy_alloc (gdl_gview_wrapper * data, const gdl_allele_block * seq, const gdl_rng * rng, size_t k);
int gdl_hstruct_fuzzy_free (gdl_hstruct_fuzzy * state);
int gdl_hstruct_fuzzy_init (gdl_hstruct_fuzzy * state);
int gdl_hstruct_fuzzy_iterate (gdl_hstruct_fuzzy * state);
int gdl_hstruct_fuzzy_imputation (gdl_hstruct_fuzzy * state);
double gdl_hstruct_fuzzy_loglikelihood (const gdl_hstruct_fuzzy * state);
double gdl_hstruct_fuzzy_residual_sq (const gdl_hstruct_fuzzy * state);
double gdl_hstruct_fuzzy_residual_abs (const gdl_hstruct_fuzzy * state);
double gdl_hstruct_fuzzy_get_pop_q (const gdl_hstruct_fuzzy * state, size_t k);
double gdl_hstruct_fuzzy_get_q (const gdl_hstruct_fuzzy * state, size_t k, size_t i);
double gdl_hstruct_fuzzy_get_f (const gdl_hstruct_fuzzy * state, size_t k, size_t l, size_t a);
size_t gdl_hstruct_fuzzy_get_f_max (const gdl_hstruct_fuzzy * state, size_t pop, size_t loc);
size_t gdl_hstruct_fuzzy_get_f_size (const gdl_hstruct_fuzzy * state, size_t loc);

__END_DECLS

#endif
