/*  
 * 	hstruct/gdl_hstruct_hmm.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:44 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_HSTRUCT_HMM_H__
#define __GDL_HSTRUCT_HMM_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_gblock.h>
#include <gdl/gdl_gpoint.h>
#include <gdl/gdl_rng.h>
#include <gdl/gdl_clustering.h>
#include <gdl/gdl_allele_block.h>
#include <gdl/gdl_vector.h>
#include <gdl/gdl_matrix.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_mask.h>
#include <gdl/gdl_gview.h>
#include <gdl/gdl_gview_collector.h>
#include <gdl/gdl_hview.h>
#include <gdl/gdl_hstruct_point.h>
#include <gdl/gdl_hstruct_config.h>
#include <gdl/gdl_hstruct_data.h>

__BEGIN_DECLS

typedef size_t (*gdl_hstruct_get_ancestral)(const void * haplotypes, size_t k, size_t l);

typedef struct
{
	// data global parameters
	size_t p;  // ploidy
	size_t n;  // number of genotypes
	size_t k;  // maximum number of ancestral clusters
	size_t missing; // the number of missing data sites
	// locus interface
	size_t l;        // number of loci
	size_t * na;     // number of alleles by locus
	size_t * lidx;   // index of loci ordered on the chromosome
	// data
	gdl_gview_wrapper * data;    // genotypic view of the sub data set
	const gdl_chromosome * chrom; // the chromosome
	// ancestral haplo interface
	const void * hdb;               // the pointer on the ancestral haplotypes (k * l)
	gdl_hstruct_get_ancestral hget; // the method to get the alleles of the ancestral haplotypes
	// observed haplotype interface 
	size_t nc;                      // the number of uniq observations
	double * weights;               // the weights of the observations
	const gdl_allele_block * seq;         // the observed haplotypes (nc * l)
	// workspace
	gdl_gvalues_get  * gbuf;
	double log;
	double * dist;
	double * norm;
	double ** alpha;
	double ** beta;
	double * delta;
	double * mdelta;
	size_t ** phi;
	gdl_block * abuf;
	gdl_block * bbuf;
	//
	double * rho;
} gdl_hstruct_hmm;

gdl_hstruct_hmm * gdl_hstruct_hmm_alloc (gdl_gview_wrapper * data, const gdl_allele_block * seq, const gdl_chromosome * chrom, const void * haplotypes, gdl_hstruct_get_ancestral get);
void  gdl_hstruct_hmm_free (gdl_hstruct_hmm * hmm);
gdl_hstruct_config * gdl_hstruct_hmm_get_locus_config (const gdl_hstruct_hmm * hmm, size_t l);
double gdl_hstruct_hmm_get_transition_proba (gdl_hstruct_hmm * hmm, const gdl_hstruct_config * c1, const gdl_hstruct_config * c2, size_t k1, size_t k2, double distance);
double gdl_hstruct_hmm_get_interval_transition_proba (gdl_hstruct_hmm * hmm, const gdl_hstruct_config * conf1, const gdl_hstruct_config * conf2, size_t k, size_t k1, size_t k2, size_t l, double pos);
double gdl_hstruct_hmm_not_recomb_proba (const gdl_hstruct_hmm * hmm, const gdl_hstruct_config * conf, double d);
int gdl_hstruct_hmm_fb_update (gdl_hstruct_hmm * hmm, gdl_boolean * update);
int gdl_hstruct_hmm_missing_update (gdl_hstruct_hmm * hmm, double * abs_res, double * sq_res);
double gdl_hstruct_hmm_get_loglikelihood (gdl_hstruct_hmm * hmm);
gdl_matrix * gdl_hstruct_hmm_get_ancestral_probs (gdl_hstruct_hmm * hmm, size_t a, size_t p);
gdl_vector_uint * gdl_hstruct_hmm_get_ancestral_path (gdl_hstruct_hmm * hmm, size_t a, size_t p);
gdl_matrix * gdl_hstruct_hmm_get_transition_matrix (gdl_hstruct_hmm * hmm, size_t l);
gdl_matrix * gdl_hstruct_hmm_get_viterbi_transition_matrix (gdl_hstruct_hmm * hmm, size_t l);
double gdl_hstruct_hmm_get_ancestral_freq (gdl_hstruct_hmm * hmm, size_t k, size_t from, size_t to);
int gdl_hstruct_hmm_store_fb_probs (gdl_hstruct_hmm * hmm);
void gdl_hstruct_hmm_clean_fb_probs (gdl_hstruct_hmm * hmm);
gdl_gdistance * gdl_hstruct_hmm_get_interval_length (const gdl_hstruct_hmm * hmm, size_t l);
gdl_vector * gdl_hstruct_hmm_get_interval_ancestral_proba (gdl_hstruct_hmm * hmm, size_t a, size_t p, size_t l, double pos);
gdl_matrix * gdl_hstruct_hmm_get_ancestral_intra_diveristy (const gdl_hstruct_hmm * hmm, gdl_vector_uint ** viterbi);
static void gdl_hstruct_hmm_mutation (const gdl_hstruct_hmm * hmm, size_t a, size_t c, size_t p, gdl_vector_uint * viterbi, gdl_vector_uint * mutation);
gdl_matrix_uint * gdl_hstruct_hmm_get_ancestral_mosaic (gdl_hstruct_hmm * hmm, size_t a, size_t p);
double gdl_hstruct_hmm_get_site_ancestral (const gdl_hstruct_hmm * hmm, size_t k, size_t c, size_t p, size_t l);
double gdl_hstruct_hmm_get_site_proba (const gdl_hstruct_hmm * hmm, size_t k, size_t c, size_t p, size_t l);
double gdl_hstruct_hmm_backward_init (gdl_hstruct_hmm * hmm, size_t c, size_t p);
double gdl_hstruct_hmm_forward_init (gdl_hstruct_hmm * hmm, size_t c, size_t p);
void gdl_hstruct_hmm_backward_induc (gdl_hstruct_hmm * hmm, size_t c, size_t p, size_t l, double * pr);
void gdl_hstruct_hmm_forward_induc (gdl_hstruct_hmm * hmm, size_t c, size_t p, size_t l, double * pr);
void gdl_hstruct_hmm_backward (gdl_hstruct_hmm * hmm, size_t c, size_t p);
void gdl_hstruct_hmm_forward (gdl_hstruct_hmm * hmm, size_t c, size_t p);
double gdl_hstruct_hmm_viterbi (gdl_hstruct_hmm * hmm, size_t c, size_t p, double * d, double * m, size_t ** phi, gdl_vector_uint * v);
double gdl_hstruct_hmm_get_alpha (const gdl_hstruct_hmm * hmm, size_t i, size_t j, size_t l, size_t k);
double gdl_hstruct_hmm_get_beta (const gdl_hstruct_hmm * hmm, size_t i, size_t j, size_t l, size_t k);

__END_DECLS

#endif /* __GDL_HSTRUCT_HMM__ */
