/*  
 * 	hstruct/gdl_hstruct_model.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:43 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_HSTRUCT_MODEL_H__
#define __GDL_HSTRUCT_MODEL_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_rng.h>
#include <gdl/gdl_gblock.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_gpartition.h>
#include <gdl/gdl_mask.h>
#include <gdl/gdl_gmap.h>
#include <gdl/gdl_view.h>
#include <gdl/gdl_pstruct.h>
#include <gdl/gdl_hstruct_data.h>
#include <gdl/gdl_hstruct_point.h>
#include <gdl/gdl_hstruct_config.h>
#include <gdl/gdl_hstruct_parameters.h>
#include <gdl/gdl_hstruct_model_type.h>
#include <gdl/gdl_hstruct_model_chromosome.h>
#include <gdl/gdl_hstruct_model_partition.h>

__BEGIN_DECLS

typedef struct _gdl_hstruct_model gdl_hstruct_model;
typedef struct _gdl_hstruct_model_mode gdl_hstruct_model_mode;

gdl_hstruct_model * gdl_hstruct_model_alloc (gdl_hstruct_data * D);
void gdl_hstruct_model_free (gdl_hstruct_model * t);

int gdl_hstruct_model_init (gdl_hstruct_model * m, const gdl_hstruct_model_mode * mode, size_t k);
int gdl_hstruct_model_init_pl (gdl_hstruct_model * m, const gdl_hstruct_model_mode * mode, size_t k, gdl_hstruct_partition_fonction f, void * extra, const gdl_gligation_type * L);

gdl_hstruct_data * gdl_hstruct_model_data (const gdl_hstruct_model * m);
const gdl_hstruct_parameters * gdl_hstruct_model_parameters (const gdl_hstruct_model * m);
const gdl_gmap * gdl_hstruct_model_locus_map (const gdl_hstruct_model * m);

size_t gdl_hstruct_model_size (const gdl_hstruct_model * t);
gdl_hstruct_model_chromosome * gdl_hstruct_model_get_chromosome (const gdl_hstruct_model * m, size_t i);
int gdl_hstruct_model_fuzzy2hmm (gdl_hstruct_model * m);
gdl_hstruct_parameter_itr * gdl_hstruct_model_parameter_iterate (const gdl_hstruct_model * model, const gdl_hstruct_point_type * T);
int gdl_hstruct_model_golden_parameter (gdl_hstruct_model * model, const gdl_hstruct_point_type * T, void * p, double * res_abs, double * res_sq);
int gdl_hstruct_model_golden_partition (gdl_hstruct_model * model, gdl_hstruct_model_partition * partition, double * res_abs, double * res_sq);
int gdl_hstruct_model_ligation (gdl_hstruct_model * t, const gdl_gligation_type * T);

size_t gdl_hstruct_model_parameter_size (const gdl_hstruct_model * model);
size_t gdl_hstruct_model_data_size (const gdl_hstruct_model * model);
double gdl_hstruct_model_loglikelihood (const gdl_hstruct_model * model);

int gdl_hstruct_model_attach_config (gdl_hstruct_model * m, gdl_hstruct_model_partition * pm, gdl_hstruct_config * conf, size_t l);

gdl_hstruct_point_handler * gdl_hstruct_model_new_handler (gdl_hstruct_model * m, const gdl_hstruct_point_type * T, void * extra);
void gdl_hstruct_model_clean_handler (gdl_hstruct_model * m, gdl_hstruct_point_handler * h);

int gdl_hstruct_model_attach_handler (gdl_hstruct_model * m, gdl_hstruct_model_partition * pm, gdl_hstruct_point_handler * h);
int gdl_hstruct_model_detach_handler (gdl_hstruct_model * m, gdl_hstruct_model_partition * pm, gdl_hstruct_point_handler * h);

gdl_hstruct_config_buffer * gdl_hstruct_model_new_buffer (gdl_hstruct_model * m, gdl_hstruct_model_partition * pm);
int gdl_hstruct_model_update (gdl_hstruct_model * m, gdl_hstruct_model_partition * pm,  gdl_hstruct_config_buffer * t, size_t l);
int gdl_hstruct_model_restore (gdl_hstruct_model * m, gdl_hstruct_model_partition * pm,  gdl_hstruct_config_buffer * t, size_t l);

int gdl_hstruct_model_backup_points (gdl_hstruct_model * m);
int gdl_hstruct_model_backup_partition_points (gdl_hstruct_model * m, gdl_hstruct_model_partition * pm);
int gdl_hstruct_model_restore_points (gdl_hstruct_model * m);
int gdl_hstruct_model_restore_partition_points (gdl_hstruct_model * m, gdl_hstruct_model_partition * pm);

void gdl_hstruct_model_config_block_update (gdl_hstruct_model * m, gdl_hstruct_config_block * b);
void gdl_hstruct_model_check_config_block (gdl_hstruct_model * m, gdl_hstruct_model_partition * pm);

gdl_hstruct_point_handler * gdl_hstruct_model_collapse_ancestral_block (gdl_hstruct_model * m, gdl_hstruct_model_partition * pm, gdl_hstruct_config_block * block, size_t k);
void gdl_hstruct_model_restore_ancestral_block (gdl_hstruct_model * m, gdl_hstruct_model_partition * pm, gdl_hstruct_config_block * block, size_t k);
gdl_hstruct_point_handler * gdl_hstruct_model_collapse_ancestral_block2 (gdl_hstruct_model * m, gdl_hstruct_model_partition * pm, gdl_hstruct_config_block * hot1, gdl_hstruct_config_block * block, gdl_hstruct_config_block * hot2, size_t k);
void gdl_hstruct_model_restore_ancestral_block2 (gdl_hstruct_model * m, gdl_hstruct_model_partition * pm, gdl_hstruct_config_block * hot1, gdl_hstruct_config_block * block, gdl_hstruct_config_block * hot2, size_t k);
gdl_hstruct_point_handler * gdl_hstruct_model_remove_hotspot_block (gdl_hstruct_model * m, gdl_hstruct_model_partition * pm, gdl_hstruct_config_block * block);
void gdl_hstruct_model_restore_hotspot_block (gdl_hstruct_model * m, gdl_hstruct_model_partition * pm, gdl_hstruct_config_block * block);

GDL_VAR const gdl_hstruct_model_mode * gdl_hstruct_model_homogeneous;
GDL_VAR const gdl_hstruct_model_mode * gdl_hstruct_model_heterogeneous;

__END_DECLS

#endif
