/*  
 * 	hstruct/gdl_hstruct_model_chromosome.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:44 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_HSTRUCT_MODEL_CHROMOSOME_H__
#define __GDL_HSTRUCT_MODEL_CHROMOSOME_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_rng.h>
#include <gdl/gdl_list.h>
#include <gdl/gdl_hash.h>
#include <gdl/gdl_clustering.h>
#include <gdl/gdl_gblock.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_gpartition.h>
#include <gdl/gdl_mask.h>
#include <gdl/gdl_gmap.h>
#include <gdl/gdl_gview.h>
#include <gdl/gdl_hview.h>
#include <gdl/gdl_fuzzy.h>
#include <gdl/gdl_hstruct_hmm.h>
#include <gdl/gdl_hstruct_data.h>
#include <gdl/gdl_hstruct_point.h>
#include <gdl/gdl_hstruct_config.h>
#include <gdl/gdl_hstruct_model_type.h>
#include <gdl/gdl_hstruct_model_partition.h>

__BEGIN_DECLS

typedef struct _gdl_hstruct_model_chromosome gdl_hstruct_model_chromosome;

typedef gdl_mask ** (*gdl_hstruct_chromosome_partition_g) (const gdl_hstruct_data * data, size_t * np);

gdl_hstruct_model_chromosome * gdl_hstruct_model_chromosome_alloc (const gdl_hstruct_data * data, size_t idx);
void gdl_hstruct_model_chromosome_free (gdl_hstruct_model_chromosome * m);

int gdl_hstruct_model_chromosome_init (gdl_hstruct_model_chromosome * m, size_t k);

typedef gdl_mask ** (*gdl_hstruct_partition_fonction)(const gdl_hstruct_data * D, const gdl_chromosome * chrom, void * extra, size_t * np);

int gdl_hstruct_model_chromosome_init_pl (gdl_hstruct_model_chromosome * m, size_t k, gdl_hstruct_partition_fonction f, void * extra, const gdl_gligation_type * L);

const gdl_mask * gdl_hstruct_model_chromosome_gmask (const gdl_hstruct_model_chromosome * m);

size_t gdl_hstruct_model_chromosome_eligible_size (const gdl_hstruct_model_chromosome * m, const gdl_gligation_type * T);
size_t gdl_hstruct_model_chromosome_size (const gdl_hstruct_model_chromosome * m);

gdl_hstruct_model_partition * gdl_hstruct_model_chromosome_get_partition (const gdl_hstruct_model_chromosome * m, size_t p);
int gdl_hstruct_model_chromosome_fuzzy2hmm (const gdl_hstruct_model_chromosome * m);
int gdl_hstruct_model_chromosome_ligation (gdl_hstruct_parameters * pr, gdl_hstruct_model_chromosome * m, const gdl_gligation_type * T);
double gdl_hstruct_model_chromosome_loglikelihood (const gdl_hstruct_model_chromosome * m);

const gdl_allele * gdl_hstruct_model_chromosome_get_ancestral (const gdl_hstruct_model_chromosome * m, size_t k, size_t l); 
void gdl_hstruct_model_chromosome_set_ancestral (const gdl_hstruct_model_chromosome * m, size_t k, size_t l, size_t a); 

GDL_VAR const gdl_hstruct_partition_fonction gdl_hstruct_split_partition;
GDL_VAR const gdl_hstruct_partition_fonction gdl_hstruct_distance_partition;

__END_DECLS

#endif
