/*  
 *  hstruct/gdl_hstruct_result.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:44 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_HSTRUCT_RESULT_H__
#define __GDL_HSTRUCT_RESULT_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_odb.h>
#include <gdl/gdl_plot.h>
#include <gdl/gdl_rng.h>
#include <gdl/gdl_gblock.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_mask.h>
#include <gdl/gdl_gmap.h>
#include <gdl/gdl_gview.h>
#include <gdl/gdl_gview_collector.h>
#include <gdl/gdl_hview.h>
#include <gdl/gdl_hview_wrapper.h>
#include <gdl/gdl_vector.h>
#include <gdl/gdl_hmap.h>
#include <gdl/gdl_hstruct_point.h>
#include <gdl/gdl_hstruct_config.h>
#include <gdl/gdl_hstruct_model.h>
#include <gdl/gdl_hstruct_block.h>
#include <gdl/gdl_hstruct.h>

__BEGIN_DECLS

typedef struct _gdl_hstruct_partition_result gdl_hstruct_partition_result;
typedef struct _gdl_hstruct_chromosome_result gdl_hstruct_chromosome_result;
typedef struct _gdl_hstruct_genome_result gdl_hstruct_genome_result;
typedef struct _gdl_hstruct_result gdl_hstruct_result;

gdl_hstruct_result * gdl_hstruct_result_alloc (const gdl_hstruct_workspace * w);
void gdl_hstruct_result_free (gdl_hstruct_result * r);

size_t gdl_hstruct_result_ploidy (const gdl_hstruct_result * r);
size_t gdl_hstruct_result_kmax (const gdl_hstruct_result * r);
size_t gdl_hstruct_result_size (const gdl_hstruct_result * r);
void * gdl_hstruct_result_parameter (const gdl_hstruct_result * r, const gdl_hstruct_point_type * T, size_t idx);
const gdl_hstruct_genome_result * gdl_hstruct_result_genome (const gdl_hstruct_result * r, size_t i);
const gdl_hstruct_static_parameter_registry * gdl_hstruct_result_parameter_registry (const gdl_hstruct_result * r);
const gdl_hstruct_model_type * gdl_hstruct_result_type (const gdl_hstruct_result * r);
const gdl_gmap * gdl_hstruct_result_gmap (const gdl_hstruct_result * r);
gdl_gmap * gdl_hstruct_result_clone_gmap (const gdl_hstruct_result * r);
gdl_gview_wrapper * gdl_hstruct_result_gview_wrapper (const gdl_hstruct_result * r, const gdl_gview * data);

size_t gdl_hstruct_genome_result_size (const gdl_hstruct_genome_result * gr);
const gdl_genome *  gdl_hstruct_genome_result_genome (const gdl_hstruct_genome_result * gr);
const gdl_hstruct_chromosome_result * gdl_hstruct_genome_result_chromosome (const gdl_hstruct_genome_result * gr, size_t i);

size_t gdl_hstruct_chromosome_result_size (const gdl_hstruct_chromosome_result *cr);
const gdl_chromosome * gdl_hstruct_chromosome_result_chromosome (const gdl_hstruct_chromosome_result *cr);
const gdl_hstruct_partition_result * gdl_hstruct_chromosome_result_partition (const gdl_hstruct_chromosome_result *cr, size_t i);

size_t gdl_hstruct_partition_result_accession_size (const gdl_hstruct_partition_result * pr);
size_t gdl_hstruct_partition_result_locus_size (const gdl_hstruct_partition_result * pr);
size_t gdl_hstruct_partition_result_ancestral_size (const gdl_hstruct_partition_result * pr);
size_t gdl_hstruct_partition_result_ancestral_locus_size (const gdl_hstruct_partition_result * pr, size_t l);

const gdl_mask       * gdl_hstruct_partition_result_gmask (const gdl_hstruct_partition_result * pr);
const gdl_clustering * gdl_hstruct_partition_result_gclust (const gdl_hstruct_partition_result * pr);
const gdl_chromosome * gdl_hstruct_partition_result_chromosome (const gdl_hstruct_partition_result * pr);
const gdl_locus      * gdl_hstruct_partition_result_locus (const gdl_hstruct_partition_result * pr, size_t i);
const gdl_accession  * gdl_hstruct_partition_result_accession (const gdl_hstruct_partition_result * pr, size_t i);
const gdl_accession  * gdl_hstruct_partition_result_search_accession (const gdl_hstruct_partition_result * pr, const gdl_string * name, gdl_hashtable ** search);
const gdl_allele     * gdl_hstruct_partition_result_ancestral_allele (const gdl_hstruct_partition_result * pr, size_t k, size_t l);
const gdl_hstruct_static_config * gdl_hstruct_partition_result_config (const gdl_hstruct_partition_result * pr, size_t i);
const gdl_gview_collector * gdl_hstruct_partition_result_gmiss (const gdl_hstruct_partition_result * pr);
const gdl_hview_wrapper * gdl_hstruct_partition_result_hmiss (const gdl_hstruct_partition_result * pr);
const gdl_hstruct_block_partition * gdl_hstruct_partition_result_block (const gdl_hstruct_partition_result * pr);

gdl_gdistance * gdl_hstruct_partition_result_interval_length (const gdl_hstruct_partition_result * pr, size_t j);
double gdl_hstruct_partition_result_ancestral_accession_proba (const gdl_hstruct_partition_result * pr, size_t k, size_t a, size_t p, size_t l);
size_t gdl_hstruct_partition_result_ancestral_accession_best (const gdl_hstruct_partition_result * pr, size_t a, size_t p, size_t l);
size_t gdl_hstruct_partition_result_ancestral_accession_best_max (const gdl_hstruct_partition_result * pr, size_t a);
double gdl_hstruct_partition_result_ancestral_accession_proba_cumul (const gdl_hstruct_partition_result * pr, size_t k, size_t a);
double gdl_hstruct_partition_result_ancestral_accession_best_cumul (const gdl_hstruct_partition_result * pr, size_t k, size_t a);
double gdl_hstruct_partition_result_ancestral_proba (const gdl_hstruct_partition_result * pr, size_t k, size_t l);
double gdl_hstruct_partition_result_ancestral_best (const gdl_hstruct_partition_result * pr, size_t k, size_t l);
double gdl_hstruct_partition_result_ancestral_recomb (const gdl_hstruct_partition_result * pr, size_t l);
double gdl_hstruct_partition_result_ancestral_length (const gdl_hstruct_partition_result * pr, size_t k);
double gdl_hstruct_partition_result_ancestral_distance (const gdl_hstruct_partition_result * pr, size_t k, size_t kk);
double gdl_hstruct_partition_result_mutation_proba (const gdl_hstruct_partition_result * p, size_t k, size_t l);
double gdl_hstruct_partition_result_average_mutation_proba (const gdl_hstruct_partition_result * p, size_t l);
double gdl_hstruct_partition_result_ancestral_diversity (const gdl_hstruct_partition_result * pr, size_t l);
gdl_boolean gdl_hstruct_partition_result_accession_is_mutated (const gdl_hstruct_partition_result * pr, size_t a, size_t p, size_t l);
gdl_vector_uint * gdl_hstruct_partition_result_accession_best_block_path (const gdl_hstruct_partition_result * pr, size_t a, size_t p);
gdl_boolean gdl_hstruct_partition_result_accession_is_missing (const gdl_hstruct_partition_result * pr, size_t a, size_t p, size_t l);

double gdl_hstruct_result_loglikelihood (const gdl_hstruct_result * r);
double gdl_hstruct_result_criterion (const gdl_hstruct_result * r, const gdl_hstruct_criterion_type * T);

size_t * gdl_hstruct_partition_result_ancestral_accession_sort (const gdl_hstruct_partition_result * p);

gdl_hstruct_result * gdl_hstruct_result_fread (FILE * stream);
int gdl_hstruct_result_fwrite (FILE * stream, const gdl_hstruct_result * r);
int gdl_hstruct_result_fprintf (FILE * stream, const gdl_hstruct_result * r);

int gdl_hstruct_result_block_extend (gdl_hstruct_result * r);
gdl_hstruct_model * gdl_hstruct_model_setup (const gdl_hstruct_result * r, const gdl_view * v, const gdl_rng * rng);

GDL_VAR const gdl_odriver   * gdl_hstruct_result_driver;
GDL_VAR const gdl_plot_type * gdl_hstruct_result_plot;

__END_DECLS

#endif
