/*  
 * 	hview/fread.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:43 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_hash.h>
#include <gdl/gdl_list.h>
#include <gdl/gdl_permutation.h>
#include <gdl/gdl_gview.h>
#include <gdl/gdl_hview.h>

int
gdl_hview_fread (FILE * stream, gdl_hview * h)
{
	if (stream == 0 || h == 0)
	{
		return GDL_EINVAL;
	}
	else
	{
		size_t i, j, k, pl;
		int status;
		
		status = fread (&pl, sizeof (size_t), 1, stream);
		GDL_FREAD_STATUS (status, 1);
		status = fread (&h->na, sizeof (size_t), 1, stream);
		GDL_FREAD_STATUS (status, 1);
		status = fread (&h->nl, sizeof (size_t), 1, stream);
		GDL_FREAD_STATUS (status, 1);
		status = fread (&h->nh, sizeof (size_t), 1, stream);
		GDL_FREAD_STATUS (status, 1);
		
		gdl_hview_init (h, h->na, h->nl, h->nh);
		
		status = fread (h->nhc, sizeof (size_t), h->na, stream);
		GDL_FREAD_STATUS (status, h->na);
		
		for (i = 0; i < h->nh; i++)
		{
			h->haplotypes[i] = GDL_MALLOC (size_t, h->nl);
			
			status = fread (h->haplotypes[i], sizeof (size_t), h->nl, stream);
			GDL_FREAD_STATUS (status, h->nl);
			status = fread (h->mult + i, sizeof (double), 1, stream);
			GDL_FREAD_STATUS (status, 1);
		}
		for (i = 0; i < h->na; i++)
		{
			
			h->hconfigs[i] = GDL_MALLOC (gdl_hconfig_ptr, h->nhc[i]);
			
			for (j = 0; j < h->nhc[i]; j++)
			{
				h->hconfigs[i][j] = gdl_hconfig_alloc (pl);
				
				status = fread (h->hconfigs[i][j]->idx, sizeof (size_t), pl, stream);
				status = fread (&(h->hconfigs[i][j]->pr), sizeof (double), 1, stream);
				GDL_FREAD_STATUS (status, 1);
			}
		}
		h->guniq = gdl_clustering_fread (stream);
		GDL_FWRITE_STATUS (h->guniq != NULL, 1);
		
		return GDL_SUCCESS;
	}
}

int
gdl_hview_fwrite (FILE * stream, const gdl_hview * h)
{
	if (stream == 0 || h == 0)
	{
		return GDL_EINVAL;
	}
	else
	{
		size_t i, j, k, pl;
		int status;
		double x;
		
		pl = gdl_hview_ploidy (h);
		
		status = fwrite (&pl, sizeof (size_t), 1, stream);
		GDL_FWRITE_STATUS (status, 1);
		status = fwrite (&h->na, sizeof (size_t), 1, stream);
		GDL_FWRITE_STATUS (status, 1);
		status = fwrite (&h->nl, sizeof (size_t), 1, stream);
		GDL_FWRITE_STATUS (status, 1);
		status = fwrite (&h->nh, sizeof (size_t), 1, stream);
		GDL_FWRITE_STATUS (status, 1);
		status = fwrite (h->nhc, sizeof (size_t), h->na, stream);
		GDL_FWRITE_STATUS (status, h->na);
		
		for (i = 0; i < h->nh; i++)
		{
			status = fwrite (h->haplotypes[i], sizeof (size_t), h->nl, stream);
			GDL_FWRITE_STATUS (status, h->nl);
			status = fwrite (h->mult + i, sizeof (double), 1, stream);
			GDL_FWRITE_STATUS (status, 1);
		}
		for (i = 0; i < h->na; i++)
		{
			for (j = 0; j < h->nhc[i]; j++)
			{
				status = fwrite (h->hconfigs[i][j]->idx, sizeof (size_t), pl, stream);
				GDL_FWRITE_STATUS (status, pl);
				x = h->hconfigs[i][j]->pr;
				status = fwrite (&x, sizeof (double), 1, stream);
				GDL_FWRITE_STATUS (status, 1);
			}
		}
		status = gdl_clustering_fwrite (stream, h->guniq);
		GDL_FWRITE_STATUS (status, GDL_SUCCESS);
		
		return GDL_SUCCESS;	
	}
}

