/*  
 * 	hview/gdl_hview.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:43 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_HVIEW_H__
#define __GDL_HVIEW_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_mask.h>
#include <gdl/gdl_gview.h>
#include <gdl/gdl_gview_collector.h>
#include <gdl/gdl_hview.h>

#define GDL_HVIEW_MAX 50000

__BEGIN_DECLS

typedef struct _gdl_hview gdl_hview;
typedef gdl_hview * gdl_hview_ptr;
typedef size_t * gdl_haplotype;
typedef struct _gdl_hconfig gdl_hconfig;
typedef gdl_hconfig * gdl_hconfig_ptr;

// HVIEW Interface

gdl_hview * gdl_hview_alloc (const gdl_gview * data, const gdl_mask * mask);
int gdl_hview_create (gdl_hview * h);
//int gdl_hview_create_pmt (gdl_hview * h, double pmt);
gdl_hview * gdl_hview_clone (const gdl_hview * h);
int gdl_hview_copy (gdl_hview * dest, const gdl_hview * src);
void gdl_hview_free (gdl_hview * h);

int gdl_hview_fread (FILE * stream, gdl_hview * h);
int gdl_hview_fwrite (FILE * stream, const gdl_hview * h);

size_t gdl_hview_ploidy (const gdl_hview * h);
size_t gdl_hview_accession_size (const gdl_hview * h);
size_t gdl_hview_accession_size_c (const gdl_hview * h);
size_t gdl_hview_accession_mult_c (const gdl_hview * h, size_t i);
size_t gdl_hview_locus_size (const gdl_hview * h);
size_t gdl_hview_locus_allele_size (const gdl_hview * h, size_t i);
size_t gdl_hview_haplotype_size (const gdl_hview * h);
gdl_locus     * gdl_hview_get_locus (const gdl_hview * h, size_t i);
gdl_accession * gdl_hview_get_accession (const gdl_hview * h, size_t i);
gdl_haplotype * gdl_hview_get_haplotype (const gdl_hview * h, size_t i);
double gdl_hview_get_haplotype_freq (const gdl_hview * h, size_t i);
void gdl_hview_set_haplotype_freq (gdl_hview * h, size_t i, double x);

gdl_gvalues_get * gdl_hview_get_new (const gdl_hview * h);
const gdl_gvalues * gdl_hview_get_gallele (const gdl_hview * h, size_t i, size_t l, size_t p, gdl_gvalues_get * gb);
const gdl_gvalues * gdl_hview_get_gallele_c (const gdl_hview * h, size_t c, size_t l, size_t p, gdl_gvalues_get * gb);
gdl_allele * gdl_hview_get_hallele (const gdl_hview * h, gdl_haplotype * haplo, size_t locus);

const gdl_gview * gdl_hview_get_gview (const gdl_hview * h);
const gdl_mask * gdl_hview_get_gmask (const gdl_hview * h);
const gdl_clustering * gdl_hview_get_clustering (const gdl_hview * h);
gdl_gview_collector * gdl_hview_get_missing_collector (const gdl_hview * h);

size_t gdl_hview_hconfig_size (const gdl_hview * h, size_t i);
gdl_hconfig  * gdl_hview_get_hconfig (const gdl_hview * h, size_t i, size_t j);
size_t gdl_hview_hconfig_size_c (const gdl_hview * h, size_t ic);
gdl_hconfig  * gdl_hview_get_hconfig_c (const gdl_hview * h, size_t ic, size_t j);

int gdl_hview_fprintf (FILE * stream, const gdl_hview * h);

gdl_hview * gdl_hview_extract (const gdl_hview * h, const gdl_mask * g);
gdl_hview * gdl_hview_kbest (const gdl_hview * h, size_t kmin);
int gdl_hview_hconfig_remove (gdl_hview * h, double pmin);
gdl_mask * gdl_hview_locus_ligation (gdl_hview * h1, const gdl_hview * h2);
int gdl_hview_locus_ligation2 (const gdl_gview * g, const gdl_mask * m, const gdl_accession_mask * ma1, const gdl_accession_mask * ma2, gdl_hview * h1, const gdl_hview * h2);

// HCONFIG Interface
size_t gdl_hconfig_get_haplotype (const gdl_hconfig * hconf, size_t i);
double gdl_hconfig_get_proba (const gdl_hconfig * hconf);
void gdl_hconfig_set_proba (gdl_hconfig * hconf, double pr);


// HAPLOTYPE Interface
gdl_haplotype gdl_haplotype_clone (const gdl_haplotype * h, size_t size);


__END_DECLS

#endif /* __GDL_HVIEW_H__ */
