/*  
 * 	hview/gdl_hview_wrapper.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:43 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_HVIEW_WRAPPER_H__
#define __GDL_HVIEW_WRAPPER_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_mask.h>
#include <gdl/gdl_gview.h>
#include <gdl/gdl_hview.h>

__BEGIN_DECLS

typedef struct _gdl_hview_wrapper gdl_hview_wrapper;

gdl_hview_wrapper * gdl_hview_wrapper_alloc (const gdl_hview * hview);
void gdl_hview_wrapper_free (gdl_hview_wrapper * h);

gdl_hview_wrapper * gdl_hview_wrapper_fread (FILE * stream);
int gdl_hview_wrapper_fwrite (FILE * stream, const gdl_hview_wrapper * h);

size_t gdl_hview_wrapper_ploidy (const gdl_hview_wrapper * h);
size_t gdl_hview_wrapper_accession_size (const gdl_hview_wrapper * h);
size_t gdl_hview_wrapper_accession_size_c (const gdl_hview_wrapper * h);
size_t gdl_hview_wrapper_accession_mult_c (const gdl_hview_wrapper * h, size_t i);
size_t gdl_hview_wrapper_locus_size (const gdl_hview_wrapper * h);
size_t gdl_hview_wrapper_locus_allele_size (const gdl_hview_wrapper * h, size_t i);
size_t gdl_hview_wrapper_haplotype_size (const gdl_hview_wrapper * h);
gdl_locus     * gdl_hview_wrapper_get_locus (const gdl_hview_wrapper * h, size_t i);
gdl_accession * gdl_hview_wrapper_get_accession (const gdl_hview_wrapper * h, size_t i);
gdl_haplotype * gdl_hview_wrapper_get_haplotype (const gdl_hview_wrapper * h, size_t i);
double gdl_hview_wrapper_get_haplotype_freq (const gdl_hview_wrapper * h, size_t i);
void gdl_hview_wrapper_set_haplotype_freq (gdl_hview_wrapper * h, size_t i, double x);

const gdl_allele * gdl_hview_wrapper_get_allele (const gdl_hview_wrapper * h, gdl_haplotype * haplo, size_t locus);

const gdl_mask * gdl_hview_wrapper_get_mask (const gdl_hview_wrapper * h);
const gdl_clustering  * gdl_hview_wrapper_get_clustering (const gdl_hview_wrapper * h);

size_t gdl_hview_wrapper_hconfig_size (const gdl_hview_wrapper * h, size_t i);
gdl_hconfig  * gdl_hview_wrapper_get_hconfig (const gdl_hview_wrapper * h, size_t i, size_t j);
size_t gdl_hview_wrapper_hconfig_size_c (const gdl_hview_wrapper * h, size_t ic);
gdl_hconfig  * gdl_hview_wrapper_get_hconfig_c (const gdl_hview_wrapper * h, size_t ic, size_t j);

gdl_hview * gdl_hview_wrapper_unwrap (const gdl_hview_wrapper * h, const gdl_gview * g);

__END_DECLS

#endif /* __GDL_HVIEW_WRAPPER_H__ */
