/*  
 * 	hview/private.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:43 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_hash.h>
#include <gdl/gdl_list.h>
#include <gdl/gdl_permutation.h>
#include <gdl/gdl_gview.h>
#include <gdl/gdl_hview.h>
 
struct _gdl_hview
{
	size_t na;
	size_t nl;
	size_t nh;
	size_t * nhc;
	gdl_hconfig_ptr ** hconfigs;
	gdl_haplotype   * haplotypes;
	double          * mult;
	const gdl_gview * data;
	const gdl_mask * mask;
	gdl_clustering  * guniq;
};

typedef struct
{
	gdl_hview * h;
	gdl_string * error;
	gdl_boolean * isa;   // ambiguous state of accessions
	size_t na;
	size_t nl;
	size_t np;
	size_t nh;
	size_t naa;    // number of ambiguous accessions
	size_t * aidx; // idx of the ambiguous accessions
	size_t * nas;  // number of ambiguous sites per accession
	size_t ** lidx; // idx of the ambiguous sites per accession
	size_t ** hbuf;
	gdl_permutation ** hpath;
	gdl_boolean * gskeep;
	size_t * gpath;
	size_t * ng;	
	gdl_genotype_ptr ** genotypes;
	double ** proba;
	double pr;
	gdl_hashtable * locus;
	gdl_hashtable * hdict;
	gdl_list      ** hconfs;
	gdl_string   ** hkeys;
	gdl_string   ** hkeyf;
	size_t        * hkeyx;
} _gdl_hview;

static _gdl_hview *
_gdl_hview_alloc (gdl_hview * h)
{
	_gdl_hview * _h 
	   = GDL_CALLOC (_gdl_hview, 1);
	_h->h     = h;
	return _h;
}

static void
_gdl_hview_free (_gdl_hview * h)
{
	if (h)
	{
		size_t i;
		GDL_FREE (h->isa);
		GDL_FREE (h->aidx);
		GDL_FREE (h->nas);
		if (h->lidx)
		{
			for (i = 0; i < h->naa; i++)
			{
				GDL_FREE (h->lidx[i]);
			}
			GDL_FREE (h->lidx);
		}
		gdl_string_free (h->error);
		GDL_FREE (h);		
	}
}

static int
gdl_hview_init (gdl_hview * h, size_t na, size_t nl, size_t nh)
{
	h->na = na;
	h->nh = nh;
	h->nl = nl;
	
	h->haplotypes = GDL_MALLOC (gdl_haplotype, nh);
	if (h->haplotypes == 0)
	{
		// error	
	}
	h->mult = GDL_CALLOC (double, nh);
	h->nhc  = GDL_MALLOC (size_t, na);
	if (h->nhc == 0)
	{
		// error
	}
	h->hconfigs = GDL_MALLOC (gdl_hconfig_ptr *, na);
	if (h->hconfigs == 0)
	{
		// error
	}
	
	return GDL_SUCCESS;
}

#include "collect.c"
#include "resolve.c"
