/*  
 * 	hview/test.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:43 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_io.h>
#include <gdl/gdl_util.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_test.h>
#include <gdl/gdl_clustering.h>
#include <gdl/gdl_mask.h>
#include <gdl/gdl_gview.h>
#include <gdl/gdl_gview_mask.h>
#include <gdl/gdl_hview.h>
#include <gdl/gdl_gview_reader.h>
#include <gdl/gdl_gview_writer.h>

gdl_gview_reader_type *
_reader_type (size_t t)
{
	gdl_gview_reader_type * type =
    	gdl_gview_reader_type_new (gdl_gview_reader_standard);
    
    switch (t)
    {
    	case 1 :
    		gdl_gview_reader_type_missing (type, "missing");
    		gdl_gview_reader_type_ploidy (type, 1);
		    return type;
    	case 2 :
		    gdl_gview_reader_type_missing (type, "0");
		    gdl_gview_reader_type_nfsep (type, " ");
		    gdl_gview_reader_type_gfsep (type, " ");
		    gdl_gview_reader_type_ploidy (type, 2);
		    gdl_gview_reader_type_locus_name (type, gdl_false);
		    gdl_gview_reader_type_is_phased (type, gdl_false);
    		return type;
    	case 3 :
		    gdl_gview_reader_type_missing (type, "0");
		    gdl_gview_reader_type_nfsep (type, " ");
		    gdl_gview_reader_type_gfsep (type, " ");
		    gdl_gview_reader_type_ploidy (type, 2);
		    gdl_gview_reader_type_locus_name (type, gdl_false);
		    gdl_gview_reader_type_is_phased (type, gdl_false);
    		return type;
    	case 4 :
    		gdl_gview_reader_type_missing (type, "N");
		    gdl_gview_reader_type_nfsep (type, " ");
		    gdl_gview_reader_type_gfsep (type, "");
		    gdl_gview_reader_type_ploidy (type, 1);
		    gdl_gview_reader_type_locus_name (type, gdl_false);
    		return type;
    }
}

gdl_gview *
_read_data (size_t t)
{
	size_t i, j;
	FILE * stream;
	gdl_string * file;
	gdl_gview_reader_type * type;
	gdl_gview_reader      * reader;
	gdl_gview * v;
	
	type = _reader_type (t);
	
	reader = gdl_gview_reader_alloc (type);
	
	file = gdl_string_sprintf ("examples/data%d.txt", t);
	
	gdl_gview_reader_open (reader, file);
	
	v = gdl_gview_reader_parse (reader);
	
	gdl_gview_reader_close (reader);
	
	gdl_gview_reader_free (reader);
	
	gdl_string_free (file);
	
	return v;	
}

int
test_create (void)
{
	size_t i, ii, j, k, np, na, nl, nh;
	gdl_gview * g;
	gdl_mask * m = NULL;
	gdl_mask * u, * osm;
	gdl_hview * h, * kh, * okh = NULL;
	gdl_clustering * gclust;
	gdl_gview_gmask_itr * itr;
	FILE * stream;
	
	g = _read_data (2);
	
	u = gdl_gview_gmask_uninformative (g, NULL, GDL_LOCUS);
	
	m = gdl_gview_gmask_uninformative (g, u, GDL_ACCESSION);
	
	gdl_mask_free (u);
	
	itr = gdl_gview_gmask_iterator (g, m, gdl_gview_gmask_heterozygous, 4);
	
	i = 0;
	
	do
	{
		gdl_mask * sm = gdl_gview_gmask_iterator_value (itr);
		
		printf ("MASK %d %d\n", i, gdl_mask_get_size (sm, GDL_LOCUS));
		
		h = gdl_hview_alloc (g, sm);
	
		gdl_hview_create (h);
		
//		kh = gdl_hview_kbest (h, 20);
//		
//		if (okh)
//		{
//			gdl_hview_locus_ligation (kh, okh);
//			gdl_hview_kbest (kh, 20);
//			gdl_hview_free (okh);
//			gdl_mask_free (osm);
//		}
//		
//		gdl_hview_free (h);
//		
//		okh = kh;
//		osm = sm;
		
		i++;
	}
	while (gdl_gview_gmask_iterator_next (itr));
	
	gdl_gview_gmask_iterator_free (itr);
	
	
//	//gdl_hview_fprintf (stdout, h);
//	
//	stream = gdl_fileopen ("test.dat", "w");
//	
//	gdl_hview_fwrite (stream, h);
//	
//	gdl_hview_free (h);
//	
//	gdl_fileclose ("test.dat", stream);
//	
//	stream = gdl_fileopen ("test.dat", "r");
//	
//	h = gdl_hview_alloc (g, m);
//	
//	gdl_hview_fread (stream, h);
//	
//	gdl_fileclose ("test.dat", stream);
//		
//	gdl_hview_fprintf (stdout, h);
//	
//	gdl_hview_free (h);
//	
    gdl_mask_free (m);
    gdl_gview_free (g);
	
	return GDL_SUCCESS;
}

int
main (void)
{
    test_create ();	
	exit (gdl_test_summary());
}
