/*  
 *  glabels/gdl_glabels.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:54 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_GLABELS_H__
#define __GDL_GLABELS_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_gview.h>
#include <gdl/gdl_gview_wrapper.h>
#include <gdl/gdl_hview.h>

__BEGIN_DECLS

typedef struct _gdl_glabels gdl_glabels;

gdl_glabels * gdl_glabels_alloc (const gdl_gview * gview, const gdl_mask * mask, const gdl_clustering * clustering, gdl_boolean last_allele);
gdl_glabels * gdl_glabels_wrapper_alloc (const gdl_gview_wrapper * gwrap, gdl_boolean accession_cluster, gdl_boolean last_allele);
gdl_glabels * gdl_glabels_wrapper_mask_alloc (const gdl_gview_wrapper * gwrap, const gdl_mask * mask, gdl_boolean last_allele);

gdl_glabels * gdl_hlabels_alloc (const gdl_hview * hview, gdl_boolean accession_cluster, gdl_boolean last_allele);

//gdl_glabels * gdl_glabels_halloc (const gdl_hview * hview, gdl_boolean accession_cluster, gdl_boolean last_allele);
void gdl_glabels_free (gdl_glabels * gl);

size_t gdl_glabels_accession_size (const gdl_glabels * gl);
size_t gdl_glabels_locus_size (const gdl_glabels * gl);
size_t gdl_glabels_locus_allele_size (const gdl_glabels * gl, size_t l);
size_t gdl_glabels_locus_genotype_size (const gdl_glabels * gl, size_t l);

const gdl_string * gdl_glabels_accession (const gdl_glabels * gl, size_t a);
const gdl_string * gdl_glabels_locus (const gdl_glabels * gl, size_t l);
const gdl_string * gdl_glabels_allele (const gdl_glabels * gl, size_t l, size_t a);
const gdl_string * gdl_glabels_genotype (const gdl_glabels * gl, size_t l, size_t a);

int gdl_glabels_allele_cumul_index (const gdl_glabels * gl, size_t a, size_t * lidx, size_t * aidx);
int gdl_glabels_genotype_cumul_index (const gdl_glabels * gl, size_t a, size_t * lidx, size_t * aidx);

int gdl_glabels_search_accession (const gdl_glabels * gl, const gdl_string * name);
int gdl_glabels_search_locus (const gdl_glabels * gl, const gdl_string * name);
int gdl_glabels_search_allele (const gdl_glabels * gl, size_t locus, const gdl_string * name);
int gdl_glabels_search_genotype (const gdl_glabels * gl, size_t locus, const gdl_string * name);

gdl_glabels * gdl_glabels_fread (FILE * stream);
int gdl_glabels_fwrite (FILE * stream, const gdl_glabels * gl);

__END_DECLS

#endif
