/*  
 * 	lasso/gdl_elastic_net.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:08 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2008 Jean-Baptiste Veyrieras.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_ELASTIC_NET_H__
#define __GDL_ELASTIC_NET_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_mode.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_math.h>
#include <gdl/gdl_permutation.h>
#include <gdl/gdl_vector.h>
#include <gdl/gdl_matrix.h>
#include <gdl/gdl_lasso.h>

__BEGIN_DECLS

typedef gdl_lasso_workspace gdl_enet_workspace;

gdl_enet_workspace * gdl_enet_workspace_alloc (const size_t n, const size_t m);
void gdl_enet_workspace_free (gdl_enet_workspace * w);
int gdl_enet_perform (gdl_enet_workspace * work,
                       gdl_matrix * X,                   
	                   gdl_vector * y,
	                   const double lambda,
	                   const gdl_boolean center,
	                   const gdl_boolean normalize,
	                   const double eps,
	                   size_t max_steps,
	                   const gdl_boolean store_beta,
	                   FILE * logger);

__END_DECLS

#endif /* GDL_ELASTIC_NET */
