/*  
 * 	lasso/gdl_lasso.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:08 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2008  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_LASSO_H__
#define __GDL_LASSO_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_mode.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_math.h>
#include <gdl/gdl_permutation.h>
#include <gdl/gdl_vector.h>
#include <gdl/gdl_matrix.h>

__BEGIN_DECLS

typedef struct _gdl_lasso_algorithm gdl_lasso_algorithm;

typedef struct
{
	size_t M;
	size_t nactive;
	size_t ninactive;
	size_t nignore;
	size_t ndrop;
	unsigned char * states;
	size_t * actives;
	size_t * inactives;
	size_t * ignores;
	size_t * drops;
	size_t * where;
} gdl_lasso_model;

gdl_lasso_model * gdl_lasso_model_alloc (const size_t m);
void gdl_lasso_model_free (gdl_lasso_model * m);
void gdl_lasso_model_reset (gdl_lasso_model * m);
void gdl_lasso_shift_predictor (gdl_lasso_model * s, const size_t p, const unsigned char which);
void gdl_lasso_pop_predictor (gdl_lasso_model * s, const size_t p, const unsigned char which);
size_t gdl_lasso_active_predictor (gdl_lasso_model * s, const size_t p);
size_t gdl_lasso_inactive_predictor (gdl_lasso_model * s, const size_t p);
void gdl_lasso_inactive_all (gdl_lasso_model * s);
size_t gdl_lasso_drop_cache_predictor (gdl_lasso_model * s, const size_t p);
size_t gdl_lasso_drop_apply_predictor (gdl_lasso_model * s);
size_t gdl_lasso_ignore_predictor (gdl_lasso_model * s, const size_t p);

typedef struct 
{
	size_t N;
	size_t M;
	gdl_lasso_model * model;
	gdl_vector * Sign;
	gdl_vector * Cvec;
	gdl_vector * C;
	gdl_vector * W;
	gdl_vector * Gi1;
	gdl_vector * av;
	gdl_vector * beta;
	gdl_vector * beta_new;
	gdl_vector * residuals;
	gdl_vector * U;
	gdl_vector * lambda;
	double ** beta_pure;
	size_t ** beta_pure_idx;
	size_t * beta_pure_size;
	size_t max_steps;
	size_t * newx;
	int    * df;
	double * normx;
	double * RSS;
	double * L1norm;
	double * penalty;
	double ssy;
	double sigma2;
	double * mux;
	double muy;
} gdl_lasso_workspace;

gdl_lasso_workspace * gdl_lasso_workspace_alloc (const size_t n, const size_t m);
void gdl_lasso_workspace_free (gdl_lasso_workspace * w);
int gdl_lasso_perform (gdl_lasso_workspace * work,
                   gdl_matrix * X,                   
                   gdl_vector * y,
                   const gdl_lasso_algorithm * algo,
                   const gdl_boolean center,
                   const gdl_boolean normalize,
                   gdl_matrix * Gram,
                   const double eps,
                   size_t max_steps,
                   const gdl_boolean use_Gram,
                   const gdl_boolean store_beta,
                   gdl_vector * weights,
                   FILE * logger);

GDL_VAR const gdl_lasso_algorithm * gdl_lasso_algorithm_lasso;
GDL_VAR const gdl_lasso_algorithm * gdl_lasso_algorithm_lar;
//GDL_VAR const gdl_lasso_algorithm * gdl_lasso_algorithm_frwstpw;
GDL_VAR const gdl_lasso_algorithm * gdl_lasso_algorithm_stpw;
GDL_VAR const gdl_lasso_algorithm * gdl_lasso_algorithm_adaptive;

__END_DECLS

#endif /* GDL_LASSO */
