/*  
 * 	linalg/gdl_linalg_svd.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:08 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_LINALG_SVD_H__
#define __GDL_LINALG_SVD_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_blas.h>
#include <gdl/gdl_matrix.h>
#include <gdl/gdl_vector.h>

__BEGIN_DECLS

typedef struct {
	gdl_string * name;
	size_t size;
	int (*alloc) (void * vsvd, size_t size1, size_t size2);
	int (*free) (void * vsvd);
	int (*perform) (void * vsvd, gdl_matrix * A, gdl_matrix * V, gdl_vector * s, size_t ns);
} gdl_linalg_svd_workspace_type;

typedef struct _gdl_linalg_svd_workspace gdl_linalg_svd_workspace;

gdl_linalg_svd_workspace * gdl_linalg_svd_workspace_alloc (const gdl_linalg_svd_workspace_type * T, size_t size1, size_t size2);
void gdl_linalg_svd_workspace_free (gdl_linalg_svd_workspace * svd);

int gdl_linalg_svd_workspace_perform (gdl_linalg_svd_workspace * svd, gdl_matrix * A, size_t ns);
int gdl_linalg_svd_workspace_const_perform (gdl_linalg_svd_workspace * svd, const gdl_matrix * A, size_t ns);

gdl_matrix * gdl_linalg_svd_workspace_const_get_left  (const gdl_linalg_svd_workspace * svd);
gdl_matrix * gdl_linalg_svd_workspace_get_right (const gdl_linalg_svd_workspace * svd);
gdl_vector * gdl_linalg_svd_workspace_get_singular (const gdl_linalg_svd_workspace * svd);
gdl_matrix * gdl_linalg_svd_workspace_get_right_ptr (const gdl_linalg_svd_workspace * svd);
gdl_vector * gdl_linalg_svd_workspace_get_singular_ptr (const gdl_linalg_svd_workspace * svd);

int gdl_linalg_SV_decomp (gdl_matrix * A, gdl_matrix * V, gdl_vector * S, gdl_vector * work);
int gdl_linalg_SV_decomp_mod (gdl_matrix * A, gdl_matrix * X, gdl_matrix * V, gdl_vector * S, gdl_vector * work);

int gdl_linalg_SV_ginv (gdl_matrix * A, gdl_matrix * V, gdl_vector * S, gdl_vector * work, gdl_matrix * gA);
int gdl_linalg_SV_ginv_mod (gdl_matrix * A, gdl_matrix * X, gdl_matrix * V, gdl_vector * S, gdl_vector * work);


GDL_VAR const gdl_linalg_svd_workspace_type * gdl_linalg_svd_golub_reinsch;
GDL_VAR const gdl_linalg_svd_workspace_type * gdl_linalg_svd_m_golub_reinsch;
GDL_VAR const gdl_linalg_svd_workspace_type * gdl_linalg_svd_sis2;

__END_DECLS

#endif /* GDL_LINALG_SVD */
