/*  
 *  locus/type.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:53 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_locus_type.h>

gdl_locus_type *
gdl_locus_type_alloc (const gdl_string * name)
{
	gdl_locus_type * t;
	
	t = GDL_MALLOC (gdl_locus_type, 1);
	
	t->name = gdl_string_clone (name);
	
	return t;
}

gdl_locus_type *
gdl_locus_type_clone (const gdl_locus_type * type)
{
	if (type)
	{
		return gdl_locus_type_alloc (type->name);
	}
	
	return NULL;
}

void
gdl_locus_type_free (gdl_locus_type * t)
{
	if (t)
	{
		gdl_string_free (t->name);
		GDL_FREE (t);	
	}
}

gdl_locus_type *
gdl_locus_type_fread (FILE * stream)
{
	if (stream)
	{
		gdl_string * name;
		
		name = gdl_string_fread (stream);
		GDL_FREAD_STATUS (name!=0, 1);
		
		return gdl_locus_type_alloc (name);
	}
	
	return NULL;	
}

int
gdl_locus_type_fwrite (FILE * stream, const gdl_locus_type * t)
{
	if (stream && t)
	{
		int status;
		
		status = gdl_string_fwrite (stream, t->name);
		GDL_FWRITE_STATUS (status, GDL_SUCCESS);
		
		return GDL_SUCCESS;
	}
	
	return GDL_EINVAL;
}	

int
gdl_locus_type_compare (const gdl_locus_type * t1, const gdl_locus_type * t2)
{
	if (t1 && t2)
	{
		return strcmp (t1->name, t2->name);	
	}
	return -1;
}

static const gdl_locus_type _gdl_locus_dna =
{
	"DNA"
};

static const gdl_locus_type _gdl_locus_indel =
{
	"INDEL"
};

static const gdl_locus_type _gdl_locus_rflp =
{
	"RFLP"
};

static const gdl_locus_type _gdl_locus_microsat =
{
	"MICROSAT"
};

const gdl_locus_type * gdl_locus_dna = &_gdl_locus_dna;
const gdl_locus_type * gdl_locus_indel = &_gdl_locus_indel;
const gdl_locus_type * gdl_locus_rflp = &_gdl_locus_rflp;
const gdl_locus_type * gdl_locus_microsat = &_gdl_locus_microsat;
