/*  
 *  mask/reverse.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:47 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_hash.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_mask.h>

void
gdl_mask_reverse (gdl_mask * m,  
                  const gdl_entity_type * T,
                  const void * data,
                  gdl_entity * (*get)(const void * data, size_t i),
                  size_t (*size)(const void * data))
{
	size_t i, j, n, p;
	gdl_mask * r = gdl_mask_alloc ();
	
	n = (*size)(data);
	p = gdl_mask_size (m, T);
	
	for (i = 0; i < n; i++)
	{
		gdl_entity * e = (*get)(data, i);
		for (j = 0; j < p; j++)
		{
			if (e->idx == gdl_mask_get_idx (m, T, j))
				break;
		}
		if (j == p)
		{
			gdl_mask_add (r, e);	
		}
	}
	gdl_mask_reset (m, T);
	gdl_mask_set (m, T, gdl_mask_get_clone (r, T), 1);
	gdl_mask_free (r);
}
