/* matrix/file_source.c
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

TYPE (gdl_matrix) *
FUNCTION (gdl_matrix, fread) (FILE * stream)
{
  int status = 0;
  size_t size1; 
  size_t size2;
  size_t tda;
  TYPE (gdl_matrix) * m;
  
  status = fread (&size1, sizeof (size_t), 1, stream);
  GDL_FREAD_STATUS (status, 1);
  status = fread (&size2, sizeof (size_t), 1, stream);
  GDL_FREAD_STATUS (status, 1);
  status = fread (&tda, sizeof (size_t), 1, stream);
  GDL_FREAD_STATUS (status, 1);
  
  m = GDL_MALLOC (TYPE (gdl_matrix), 1);
  
  m->size1 = size1;
  m->size2 = size2;
  m->tda   = tda;
  m->owner = 1;

  m->block = FUNCTION (gdl_block, fread) (stream);
  
  m->data = m->block->data;

  return m;
}

int
FUNCTION (gdl_matrix, fwrite) (FILE * stream, const TYPE (gdl_matrix) * m)
{
  int status = 0;
  const size_t size1 = m->size1; 
  const size_t size2 = m->size2;
  const size_t tda = m->tda;

  status = fwrite (&size1, sizeof (size_t), 1, stream);
  GDL_FWRITE_STATUS (status, 1);
  status = fwrite (&size2, sizeof (size_t), 1, stream);
  GDL_FWRITE_STATUS (status, 1);
  status = fwrite (&tda, sizeof (size_t), 1, stream);
  GDL_FWRITE_STATUS (status, 1);
  status = FUNCTION (gdl_block, fwrite) (stream, m->block);
  GDL_FWRITE_STATUS (status, GDL_SUCCESS);
  
  return status;

}

#if !(USES_LONGDOUBLE && !HAVE_PRINTF_LONGDOUBLE)
int
FUNCTION (gdl_matrix, fprintf) (FILE * stream, const TYPE (gdl_matrix) * m,
                                const char *format)
{
  int status = 0;

  const size_t size1 = m->size1; 
  const size_t size2 = m->size2;

  const size_t tda = m->tda;

  if (tda == size2) /* the rows are contiguous */
    {
      status = FUNCTION (gdl_block, raw_fprintf) (stream, 
                                                  m->data, 
                                                  size1 * size2, 1,
                                                  format);
    }
  else
    {
      size_t i;

      for (i = 0 ; i < size1 ; i++)  /* print each row separately */
        {
          status = FUNCTION (gdl_block, raw_fprintf) (stream, 
                                                      m->data + i * tda, 
                                                      size2, 1,
                                                      format);
          if (status)
            break;
        }
    }

  return status;
}

int
FUNCTION (gdl_matrix, fscanf) (FILE * stream, TYPE (gdl_matrix) * m)
{
  int status = 0;

  const size_t size1 = m->size1; 
  const size_t size2 = m->size2;

  const size_t tda = m->tda;

  if (tda == size2)  /* the rows are contiguous */
    {
      status = FUNCTION (gdl_block, raw_fscanf) (stream, 
                                                 m->data, 
                                                 size1 * size2, 1);
    }
  else
    {
      size_t i;

      for (i = 0 ; i < size1 ; i++)  /* scan each row separately */
        {
          status = FUNCTION (gdl_block, raw_fscanf) (stream, 
                                                     m->data + i * tda, 
                                                     size2, 1);
          if (status)
            break;
        }
    }

  return status;
}
#endif

