/* min/gdl_min.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000 Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GDL_MIN_H__
#define __GDL_MIN_H__

#include <stdlib.h>
#include <gdl/gdl_common.h>
#include <gdl/gdl_types.h>
#include <gdl/gdl_math.h>


__BEGIN_DECLS

typedef struct
  {
    const char *name;
    size_t size;
    int (*set) (void *state, gdl_function * f, double x_minimum, double f_minimum, double x_lower, double f_lower, double x_upper, double f_upper);
    int (*iterate) (void *state, gdl_function * f, double * x_minimum, double * f_minimum, double * x_lower, double * f_lower, double * x_upper, double * f_upper);
  }
gdl_min_fminimizer_type;

typedef struct
  {
    const gdl_min_fminimizer_type * type;
    gdl_function * function ;
    double x_minimum ;
    double x_lower ;
    double x_upper ;
    double f_minimum, f_lower, f_upper;
    void *state;
  }
gdl_min_fminimizer;

gdl_min_fminimizer *
gdl_min_fminimizer_alloc (const gdl_min_fminimizer_type * T) ;
                                      
void gdl_min_fminimizer_free (gdl_min_fminimizer * s);

int gdl_min_fminimizer_set (gdl_min_fminimizer * s, 
                            gdl_function * f, double x_minimum, 
                            double x_lower, double x_upper);

int gdl_min_fminimizer_set_with_values (gdl_min_fminimizer * s, 
                                        gdl_function * f, 
                                        double x_minimum, double f_minimum,
                                        double x_lower, double f_lower,
                                        double x_upper, double f_upper);

int gdl_min_fminimizer_iterate (gdl_min_fminimizer * s);

const char * gdl_min_fminimizer_name (const gdl_min_fminimizer * s);

double gdl_min_fminimizer_x_minimum (const gdl_min_fminimizer * s);
double gdl_min_fminimizer_x_lower (const gdl_min_fminimizer * s);
double gdl_min_fminimizer_x_upper (const gdl_min_fminimizer * s);
double gdl_min_fminimizer_f_minimum (const gdl_min_fminimizer * s);
double gdl_min_fminimizer_f_lower (const gdl_min_fminimizer * s);
double gdl_min_fminimizer_f_upper (const gdl_min_fminimizer * s);

/* Deprecated, use x_minimum instead */
double gdl_min_fminimizer_minimum (const gdl_min_fminimizer * s);

int
gdl_min_test_interval (double x_lower, double x_upper, double epsabs, double epsrel);

GDL_VAR const gdl_min_fminimizer_type  * gdl_min_fminimizer_goldensection;
GDL_VAR const gdl_min_fminimizer_type  * gdl_min_fminimizer_brent;

typedef
int (*gdl_min_bracketing_function)(gdl_function *f,
                                   double *x_minimum,double * f_minimum,
                                   double *x_lower, double * f_lower,
                                   double *x_upper, double * f_upper,
                                   size_t eval_max);

int 
gdl_min_find_bracket(gdl_function *f,double *x_minimum,double * f_minimum,
                     double *x_lower, double * f_lower,
                     double *x_upper, double * f_upper,
                     size_t eval_max);

__END_DECLS

#endif /* __GDL_MIN_H__ */
