/*  
 *  mosaic/forward.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:01 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <float.h>
 
#include <gdl/gdl_common.h>
#include <gdl/gdl_rng.h>
#include <gdl/gdl_randist.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_mask.h>
#include <gdl/gdl_allele_block.h>
#include <gdl/gdl_gview_wrapper.h>
#include <gdl/gdl_mosaic.h>

void
gdl_mosaic_hmm_backward (gdl_mosaic * hmm, size_t c, size_t p, double (*obs_proba)(gdl_mosaic * hmm, size_t k, size_t c, size_t l, size_t p))
{
	size_t j;
	double pr;
	
	pr = gdl_mosaic_hmm_backward_init (hmm, c, p, obs_proba);
	for (j = hmm->data->L-1; j >= 1; j--)
	{
		gdl_mosaic_hmm_backward_induc (hmm, c, p, j-1, &pr, obs_proba);
	}	
}

double
gdl_mosaic_hmm_backward_init (gdl_mosaic * hmm, size_t c, size_t p, double (*obs_proba)(gdl_mosaic * hmm, size_t k, size_t c, size_t l, size_t p))
{
	size_t k, l = hmm->data->L-1;
	double x, y, pr = 0;
	
	for(k = 0; k < hmm->clust->K; k++)
	{
		x = (*obs_proba)(hmm, k, c, p, l);
		y = hmm->param->f[l][k];
		hmm->util->beta[l][k] = 1.0;
		pr += x * y * hmm->util->beta[l][k];
	}	
	return pr;
}

void
gdl_mosaic_hmm_backward_induc (gdl_mosaic * hmm, size_t c, size_t p, size_t l, double * pr, double (*obs_proba)(gdl_mosaic * hmm, size_t k, size_t c, size_t l, size_t p))
{
	size_t k;
	double x, t, u, v, s, ss = 0;
	
	t = gdl_mosaic_hmm_norec_proba (hmm, l, hmm->data->D[l]);
	s = *pr;
	for (k = 0; k < hmm->clust->K; k++)
	{
		x  = hmm->util->beta[l+1][k];
		u  = (*obs_proba)(hmm, k, c, p, l+1);
		x  *= t;
		x  *= u;
		x  += (1.0-t)*s;
		hmm->util->beta[l][k] = x/hmm->util->norm[l];
		u = (*obs_proba)(hmm, k, c, p, l);
		v = hmm->param->f[l][k];
		ss += u*v*hmm->util->beta[l][k];
	}
	*pr = ss;
}
