/*  
 *  mosaic/gdl_mosaic_result.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:01 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_MOSAIC_RESULT_H__
#define __GDL_MOSAIC_RESULT_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_allele_block.h>
#include <gdl/gdl_gview_collector.h>
#include <gdl/gdl_glabels.h>
#include <gdl/gdl_result.h>
#include <gdl/gdl_plot.h>
#include <gdl/gdl_mosaic.h>

__BEGIN_DECLS

typedef struct
{
	size_t N;
	size_t L;
	size_t P;
	size_t K;
	size_t * NA;
	double * D;
	double log;
	double * rho;
	double * mu;
	double ** f;
	gdl_allele_block    * haplo;
	gdl_allele_block    * viterbi;
	gdl_gview_collector * missing;
	gdl_glabels         * labels;
	gdl_chromosome      * chrom;
	gdl_clustering      * clust;
} gdl_mosaic_result;

gdl_mosaic_result * gdl_mosaic_result_alloc (gdl_mosaic * mosaic);
void gdl_mosaic_result_free (gdl_mosaic_result * r);

gdl_mosaic_result * gdl_mosaic_result_fread (FILE * stream);
int gdl_mosaic_result_fwrite (FILE * stream, const gdl_mosaic_result * r);
int gdl_mosaic_result_fprintf (FILE * stream, const gdl_mosaic_result * r);

size_t * gdl_mosaic_result_sort_accession (const gdl_mosaic_result * r);
size_t gdl_mosaic_result_best_path (const gdl_mosaic_result * r, size_t a, size_t l, size_t p);

gdl_mosaic * gdl_mosaic_result_setup (const gdl_mosaic_result * r, gdl_gview_wrapper * data, const gdl_rng * rng);

GDL_VAR const gdl_odriver * gdl_mosaic_result_driver;
GDL_VAR const gdl_plot_type * gdl_mosaic_result_plot;

__END_DECLS

#endif
