/*  
 *  mosaic/forward.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:01 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <float.h>
 
#include <gdl/gdl_common.h>
#include <gdl/gdl_rng.h>
#include <gdl/gdl_randist.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_mask.h>
#include <gdl/gdl_allele_block.h>
#include <gdl/gdl_gview_wrapper.h>
#include <gdl/gdl_mosaic.h>

double
gdl_mosaic_hmm_obs_proba_theta (gdl_mosaic * hmm, size_t k, size_t c, size_t p, size_t l)
{
	if (!gdl_mosaic_data_is_missing(hmm->data, c, l))
	{
		return gdl_frequencies_block_get (hmm->clust->theta, k, l, gdl_mosaic_data_get_allele (hmm->data, c, l, p));
	}
	else
	{
		return 1.0;
	}
}

double
gdl_mosaic_hmm_obs_proba_haplo (gdl_mosaic * hmm, size_t k, size_t c, size_t p, size_t l)
{
	if (!gdl_mosaic_data_is_missing(hmm->data, c, l))
	{
		size_t haplo  = gdl_allele_block_get (hmm->clust->haplo, k, l, 0);
		size_t allele = gdl_mosaic_data_get_allele (hmm->data, c, l, p);
		return (haplo==allele) ? 1-hmm->param->mu[l] : hmm->param->mu[l]/(hmm->data->NA[l]-1);
	}
	else
	{
		return 1.0;
	}
}

double
gdl_mosaic_hmm_norec_proba (gdl_mosaic * hmm, size_t l, double d)
{
	if (d >= 0.0)
	{
		return exp(-hmm->param->rho[l]*d);
	}
	else
	{
		return exp(-hmm->param->rho[l]);
	}
}

double
gdl_mosaic_hmm_trans_proba (gdl_mosaic * hmm, size_t l, size_t k1, size_t k2, double d)
{
	double t, x;
	
	t = gdl_mosaic_hmm_norec_proba (hmm, l, d);
	x = (1-t)*hmm->param->f[l+1][k2];
	if (k1 == k2) x += t;
	return x;
}

