/*  
 *  mosaic/setup.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:01 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <float.h>
 
#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_mask.h>
#include <gdl/gdl_list.h>
#include <gdl/gdl_allele_block.h>
#include <gdl/gdl_gview_collector.h>
#include <gdl/gdl_mosaic.h>
#include <gdl/gdl_mosaic_result.h>

gdl_mosaic *
gdl_mosaic_result_setup (const gdl_mosaic_result * r, gdl_gview_wrapper * data, const gdl_rng * rng)
{
	size_t i;
	gdl_mosaic * w;
	
	w = gdl_mosaic_alloc	(r->K, r->chrom, data, rng);
	
	gdl_allele_block_free (w->clust->haplo);
	
	w->clust->haplo = gdl_allele_block_clone (r->haplo);
	
	memcpy (w->param->rho, r->rho, sizeof (double)*(r->L-1));
	memcpy (w->param->mu, r->mu, sizeof (double)*r->L);
	for (i = 0; i < w->data->L; i++)
	{
		memcpy (w->param->f[i], r->f[i], sizeof(double)*r->K);	
	}
		
	return w;
}
