/*  
 *  mosaic/update.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:01 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <float.h>
 
#include <gdl/gdl_common.h>
#include <gdl/gdl_rng.h>
#include <gdl/gdl_randist.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_mask.h>
#include <gdl/gdl_allele_block.h>
#include <gdl/gdl_gview_wrapper.h>
#include <gdl/gdl_mosaic.h>

void
gdl_mosaic_hmm_update_theta (gdl_mosaic * hmm, const size_t c, const size_t p)
{
	size_t l, a, k, kk;
	double z, x, y, t, tot;
	const size_t L = hmm->data->L;
	const size_t K = hmm->clust->K;
	
	for (l = 0; l < L; l++)
	{
		if (!gdl_mosaic_data_is_missing(hmm->data, c, l))
		{
			a = gdl_mosaic_data_get_allele (hmm->data, c, l, p);
			if (l < L-1) 
			{
				t = 1-gdl_mosaic_hmm_norec_proba (hmm, l, hmm->data->D[l]);
			}
			for (tot = k = 0; k < K; k++)
			{
			   tot += hmm->util->alpha[l][k]*hmm->util->beta[l][k];
			}
			for (y = 0, k = 0; k < K; k++)
			{
				z  = hmm->util->alpha[l][k]*hmm->util->beta[l][k]/tot;
				z *= hmm->data->W[c];
				hmm->param->update_f[l][k] += z;
				x = gdl_frequencies_block_get (hmm->clust->update_theta, k, l, a);
				gdl_frequencies_block_set (hmm->clust->update_theta, k, l, a, x + z);
				if (l < L-1)
				{
					for (kk = 0; kk < K; kk++)
					{
						if (kk == k) continue;
						x  = t*hmm->param->f[l+1][kk];
						x *= gdl_mosaic_hmm_obs_proba_theta (hmm, kk, c, p, l+1);
						x *= hmm->util->alpha[l][k]*hmm->util->beta[l+1][kk];
						y += x/tot;
					}
				}
			}
			if (l < L-1) 
			{
				hmm->param->update_rho[l] += hmm->data->W[c]*y;
				hmm->param->rho_count[l]  += hmm->data->W[c];
			}
		}
	}
} 

void
gdl_mosaic_hmm_update_haplo (gdl_mosaic * hmm, const size_t c, const size_t p)
{
	size_t l, obs, anc, k, kk;
	double z, x, y, t, tot;
	const size_t L = hmm->data->L;
	const size_t K = hmm->clust->K;
	
	for (l = 0; l < L; l++)
	{
		if (!gdl_mosaic_data_is_missing(hmm->data, c, l))
		{
			obs = gdl_mosaic_data_get_allele (hmm->data, c, l, p);
			if (l < L-1) 
			{
				t = 1-gdl_mosaic_hmm_norec_proba (hmm, l, hmm->data->D[l]);
			}
			for (tot = k = 0; k < K; k++)
			{
			   tot += hmm->util->alpha[l][k]*hmm->util->beta[l][k];
			}
			for (y = 0, k = 0; k < K; k++)
			{
				z  = hmm->util->alpha[l][k]*hmm->util->beta[l][k]/tot;
				z *= hmm->data->W[c];
				hmm->param->update_f[l][k] += z;
				anc = gdl_allele_block_get (hmm->clust->haplo, k, l, 0);
				if (obs != anc)
				{
					hmm->param->update_mu[l] += z;
				}
				if (l < L-1)
				{
					for (kk = 0; kk < K; kk++)
					{
						if (kk == k) continue;
						x  = t*hmm->param->f[l+1][kk];
						x *= gdl_mosaic_hmm_obs_proba_haplo (hmm, kk, c, p, l+1);
						x *= hmm->util->alpha[l][k]*hmm->util->beta[l+1][kk];
						y += x/tot;
					}
				}
			}
			if (l < L-1) 
			{
				hmm->param->update_rho[l] += hmm->data->W[c]*y;
				hmm->param->rho_count[l]  += hmm->data->W[c];
			}
		}
	}
}

