/*  
 *  mosaic/viterbi.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:01 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <float.h>
 
#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_vector.h>
#include <gdl/gdl_rng.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_gview_wrapper.h>
#include <gdl/gdl_mosaic.h>

gdl_vector_uint *
gdl_mosaic_hmm_viterbi (gdl_mosaic * hmm, size_t c, size_t p, double (*obs_proba)(gdl_mosaic * hmm, size_t k, size_t c, size_t l, size_t p))
{
	size_t k, kk, l;
	double max, u;
	const size_t L = hmm->data->L;
	const size_t K = hmm->clust->K;
	gdl_vector_uint * v;
	
	v = gdl_vector_uint_alloc (L);
	
	// initialization
	for (k = 0; k < K; k++)
	{
		hmm->util->d[k] = log (hmm->param->f[0][k]);
		hmm->util->d[k] += log ((*obs_proba)(hmm, k, c, p, 0));
	}
	// recursion
	for (l = 0; l < L-1; l++)
	{
		for (kk = 0; kk < K; kk++)
		{
			hmm->util->m[kk] = GDL_NEGINF;
			for (k = 0; k < K; k++)
			{
				u = gdl_mosaic_hmm_trans_proba (hmm, l, k, kk, hmm->data->D[l]);
				u = log (u) + hmm->util->d[k];
				if (u > hmm->util->m[kk])
				{
					hmm->util->m[kk]       = u;
					hmm->util->phi[kk][l]  = k;
				}
			}					
		}
		for (k = 0; k < K; k++)
		{
			hmm->util->d[k]  = hmm->util->m[k];
			hmm->util->d[k] += log ((*obs_proba)(hmm, k, c, p, l+1));
		}
	}
	// termination
	for (u = GDL_NEGINF, k = 0; k < K; k++)
	{
		if (hmm->util->d[k] > u)
		{
			u = hmm->util->d[k];
			gdl_vector_uint_set (v, l, k);
		}
	}
	// backtracking
	for (k = L - 1; k > 0; k--)
	{
		l  = k - 1;
		kk = gdl_vector_uint_get (v, l+1);
		gdl_vector_uint_set (v, l, hmm->util->phi[kk][l]);
	}
	
	return v;
}
