static int
set (void *vstate, gdl_multifit_function_fdf * fdf, gdl_vector * x, gdl_vector * f, gdl_matrix * J, gdl_vector * dx, int scale)
{
  lmder_state_t *state = (lmder_state_t *) vstate;

  gdl_matrix *r = state->r;
  gdl_vector *tau = state->tau;
  gdl_vector *diag = state->diag;
  gdl_vector *work1 = state->work1;
  gdl_permutation *perm = state->perm;

  int signum;

  GDL_MULTIFIT_FN_EVAL_F_DF (fdf, x, f, J);

  state->par = 0;
  state->iter = 1;
  state->fnorm = enorm (f);

  gdl_vector_set_all (dx, 0.0);

  /* store column norms in diag */

  if (scale)
    {
      compute_diag (J, diag);
    }
  else
    {
      gdl_vector_set_all (diag, 1.0);
    }

  /* set delta to 100 |D x| or to 100 if |D x| is zero */

  state->xnorm = scaled_enorm (diag, x);
  state->delta = compute_delta (diag, x);

  /* Factorize J into QR decomposition */

  gdl_matrix_memcpy (r, J);
  gdl_linalg_QRPT_decomp (r, tau, perm, &signum, work1);

  return GDL_SUCCESS;
}
