/* multimin/convergence.c
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000 Fabrice Rossi
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <config.h>
#include <gdl/gdl_multimin.h>
#include <gdl/gdl_blas.h>

int
gdl_multimin_test_gradient (const gdl_vector *g, double epsabs)
{
  double norm;

  if (epsabs < 0.0)
    {
      GDL_ERROR ("absolute tolerance is negative", GDL_EBADTOL);
    }

  norm = gdl_blas_dnrm2(g);
  
  if (norm < epsabs)
    {
      return GDL_SUCCESS;
    }

  return GDL_CONTINUE;
}

int
gdl_multimin_test_size (const double size, double epsabs)
{
  if (epsabs < 0.0)
    {
      GDL_ERROR ("absolute tolerance is negative", GDL_EBADTOL);
    }
  
  if (size < epsabs)
    {
      return GDL_SUCCESS;
    }

  return GDL_CONTINUE;
}
