/* All the subroutines in this file come from


    Numerical Recipes in C, The Art of Scientific Computing
  by W. H. Press, B. P. Flannery, S. A. Teukolsky and W. T. Vetterling.
  1990, Cambridge University Press, Cambridge, England
  ISBN 0-521-35465-X  (the book)
  

*/
#ifndef __GDL_NREC_H__
#define __GDL_NREC_H__

#include <math.h>

#include <gdl/gdl_common.h>
#include <gdl/gdl_rng.h>


__BEGIN_DECLS

#define GDL_NREC_ALF	1.0e-4
#define GDL_NREC_TOLX	1.0e-7
#define GDL_NREC_STPMX	100.0
#define GDL_NREC_GOLD	1.618034
#define GDL_NREC_GLIMIT 100.0
#define GDL_NREC_TINY 1.0e-20
#define GDL_NREC_ITMAX 100
#define GDL_NREC_EPS 3.0e-8
#define GDL_NREC_ZEPS 1.0e-10
#define GDL_NREC_SVDITMAX 1000
#define GDL_NREC_TOL (4*GDL_NREC_EPS)
#define GDL_NREC_CGOLD 0.3819660
#define GDL_NREC_SQR(a) ((a) == 0.0 ? 0.0 : (a)*(a))
#define GDL_NREC_SIGN(a, b) ((b) > 0.0 ? fabs(a) : -fabs(a))
#define GDL_NREC_SHFT(a,b,c,d) (a)=(b);(b)=(c);(c)=(d);
#define GDL_NREC_MOV3(a,b,c,d,e,f) (a)=(d);(b)=(e);(c)=(f);

void iindexx(int n, int arrin[],int indx[]);
void   indexx(int n, double arrin[],int indx[]);
void   moment(double data[],int n,double  *ave,double  *adev,double  *sdev,double  *svar,double  *skew,double  *curt);
void   sort(int n,double ra[]);
void   fsort(int n,float ra[]);
void   isort(int n,int ra[]);

double gammln(double xx);
double gammp(double a,double  x);
double gasdev(int *idum);
void   gcf( double *gammcf,double a, double x, double *gln);
void   gser( double *gamser, double a, double x, double *gln);
double poidev(double xm,int *idum);
double betai(double a,double  b,double  x);
double beta(double z,double  w);
double betacf(double a,double  b,double  x);
double dpythag(double a, double b);
float  pythag(float a, float b);
void   dsvbksb(
																	double **u,
																	double *w,
																	double **v,
																	int m,
																	int n,
																	double *b,
																	double *x
																);
int dsvdcmp(double **a, int m, int n, double *w, double **v);
void dsvdmfit(double **a, double *y, double *sig, int ndata, double *c, int ma,
	                       double **u, double **v, double *w, double *chisq,
	                       double **cov, int itrcpt);
void sortIndex(int n,double ra[], int index[]);
void fsortIndex(int n,float ra[], int index[]);
void cov_matrix(double **cov, double **data, int pp, int nn);
void cor_matrix(double **cov, double **data, int pp, int nn);
void tred2(double **a, int n, double *d, double *e);
void tlqi(double *d, double *e, int n, double **z);
double stats_mean(double *x, int n);
double stats_variance(double *x, int n);
double stats_variance_m(double *x, int n, double mean);
float stats_fmean(float *x, int n);
float stats_fvariance(float *x, int n);
float stats_fvariance_m(float *x, int n, float mean);
double stats_cov_mcol(double **data, int ii, int jj, int nn);
void varimax(
				double **x,
				double **TT,
				double **z,
				double **b,
				double **v,
				double *w,
				double *sc,
				double eps,
				int p,
				int nc);
void dlnsrch1(
			int n,
			double xold[],
			double fold,
			double g[],
			double p[],
			double x[],
			double *f,
			double stpmax,
			int *check,
			double (*func)(double [], void *param),
			void *param
			);
double brent(double ax, double bx, double cx, double (*f)(double), double tol, double *xmin);
int dbrent(double ax, double bx, double cx, double (*f)(double), double (*df)(double), double tol, double *xmin, double *fret);
void mnbrak(double *ax, double *bx, double *cx, double *fa, double *fb, double *fc, double (*func)(double));
void dcntab1(double **nn, int ni, int nj, double *chisq, double *df, double *prob, double *cranrv, double *ccc);
void damebsa(
			  gdl_rng *rng,
			  double **p,
			  double y[],
			  int ndim,
			  double pb[],
			  double *yb,
			  double ftol,
			  double (*funk)(double [], void *param, int *status),
			  int *iter,
			  double temptr,
			  void *param
			  );
double damotsa(gdl_rng *rng, double **p, double y[], double psum[], int ndim, double pb[], double *yb, double (*funk)(double [], void *param, int *status), int ihi, double *yhi, double fac, double temptr, void *param);
void ddfpmin(double p[], int n, double gtol, int *iter, double *fret, double (* func)(double *x, void *param, int *status), int (* dfunc)(double *x, double *g, void *param), void *param);
void dlnsrch(
			int n,
			double xold[],
			double fold,
			double g[],
			double p[],
			double x[],
			double *f,
			double stpmax,
			int *check,
			double (*func)(double *x, void *param, int *status),
			void *param
			);
int draw_ball(double cumul[], int nb, gdl_rng *rng);
int draw_ball_tot(double cumul[], double tot, int nb, gdl_rng *rng);
int draw_ball_from_to(double cumul[], double from, double to, int nb, gdl_rng *rng);
void dbalance_vector(double w[], int n, double tol);
void dbalance_matrix_column(double **x, double eps, int nh, int nl, int ph, int pl);
void dbalance_matrix_row(double **x, double eps, int nh, int nl, int ph, int pl);
void moore_penrose_inversion(double **m, int n, int p, double **im, double *s, double **v);
int dcholdc(double **a, int n, double p[]);
double dgolden(double ax, double bx, double cx, double (*f)(double), double tol, double *xmin);

long gdl_factorial (size_t n);

__END_DECLS

#endif

